---
title: Changelog · Cloudflare One docs
description: Review recent changes to Cloudflare One.
lastUpdated: 2025-11-18T20:09:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/changelog/
  md: https://developers.cloudflare.com/cloudflare-one/changelog/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/cloudflare-one.xml)

## 2025-11-17

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New Cloudflare One Navigation and Product Experience**

The Zero Trust dashboard and navigation is receiving significant and exciting updates. The dashboard is being restructured to better support common tasks and workflows, and various pages have been moved and consolidated.

There is a new guided experience on login detailing the changes, and you can use the Zero Trust dashboard search to find product pages by both their new and old names, as well as your created resources. To replay the guided experience, you can find it in Overview > Get Started.

![Cloudflare One Dash Changes](https://developers.cloudflare.com/_astro/cf1-dash-changes.Uk_Y-2V-_1OJ1r7.webp)

Notable changes

* Product names have been removed from many top-level navigation items to help bring clarity to what they help you accomplish. For example, you can find Gateway policies under ‘Traffic policies’ and CASB findings under ‘Cloud & SaaS findings.’
* You can view all analytics, logs, and real-time monitoring tools from ‘Insights.’
* ‘Networks’ better maps the ways that your corporate network interacts with Cloudflare. Some pages like Tunnels, are now a tab rather than a full page as part of these changes. You can find them at Networks > Connectors.
* Settings are now located closer to the tools and resources they impact. For example, this means you’ll find your WARP configurations at Team & Resources > Devices.

![New Cloudflare One Navigation](https://developers.cloudflare.com/_astro/new-cf1-navigation.B7-E-9CV_Z1b4O9p.webp)

No changes to our API endpoint structure or to any backend services have been made as part of this effort.

## 2025-11-14

[CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

**New SaaS Security weekly digests with API CASB**

You can now stay on top of your SaaS security posture with the new **CASB Weekly Digest** notification. This opt-in email digest is delivered to your inbox every Monday morning and provides a high-level summary of your organization's Cloudflare API CASB findings from the previous week.

This allows security teams and IT administrators to get proactive, at-a-glance visibility into new risks and integration health without having to log in to the dashboard.

To opt in, navigate to **Manage Account** > **Notifications** in the Cloudflare dashboard to configure the **CASB Weekly Digest** alert type.

#### Key capabilities

* **At-a-glance summary** — Review new high/critical findings, most frequent finding types, and new content exposures from the past 7 days.
* **Integration health** — Instantly see the status of all your connected SaaS integrations (Healthy, Unhealthy, or Paused) to spot API connection issues.
* **Proactive alerting** — The digest is sent automatically to all subscribed users every Monday morning.
* **Easy to configure** — Users can opt in by enabling the notification in the Cloudflare dashboard under **Manage Account** > **Notifications**.

#### Learn more

* Configure [notification preferences](https://developers.cloudflare.com/notifications/) in Cloudflare.

The CASB Weekly Digest notification is available to all Cloudflare users today.

## 2025-11-11

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.9.558.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes, improvements, and new features including [Path Maximum Transmission Unit Discovery (PMTUD)](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery). When PMTUD is enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to diagnose connectivity issues.

**Changes and improvements**

* Fixed an inconsistency with [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) settings in multi-user environments when switching between users.
* The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to diagnose connectivity issues.
* Fixed an issue where deleting a registration was erroneously reported as having failed.
* Path Maximum Transmission Unit Discovery (PMTUD) may now be used to discover the effective MTU of the connection. This allows the WARP client to improve connectivity optimized for each network. PMTUD is disabled by default. To enable it, refer to the [PMTUD documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery).
* Improvements for the [OS version](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/os-version/) WARP client check. Windows Updated Build Revision (UBR) numbers can now be checked by the client to ensure devices have required security patches and features installed.
* The WARP client now supports Windows 11 ARM-based machines. For information on known limitations, refer to the [Known limitations page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/known-limitations/#warp-disconnected-on-windows-arm).

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-11-11

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.9.558.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes, improvements, and new features including [Path Maximum Transmission Unit Discovery (PMTUD)](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery). When PMTUD is enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to diagnose connectivity issues.

**Changes and improvements**

* The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to diagnose connectivity issues.
* Fixed an issue where deleting a registration was erroneously reported as having failed.
* Path Maximum Transmission Unit Discovery (PMTUD) may now be used to discover the effective MTU of the connection. This allows the WARP client to improve connectivity optimized for each network. PMTUD is disabled by default. To enable it, refer to the [PMTUD documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery).

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-11-11

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.9.558.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes, improvements, and new features including [Path Maximum Transmission Unit Discovery (PMTUD)](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery). When PMTUD is enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to diagnose connectivity issues.

WARP client version 2025.8.779.0 introduced an updated public key for Linux packages. The public key must be updated if it was installed before September 12, 2025 to ensure the repository remains functional after December 4, 2025. Instructions to make this update are available at [pkg.cloudflareclient.com](https://pkg.cloudflareclient.com/).

**Changes and improvements**

* The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to diagnose connectivity issues.
* Fixed an issue where deleting a registration was erroneously reported as having failed.
* Path Maximum Transmission Unit Discovery (PMTUD) may now be used to discover the effective MTU of the connection. This allows the WARP client to improve connectivity optimized for each network. PMTUD is disabled by default. To enable it, refer to the [PMTUD documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery).

## 2025-11-11

[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

**cloudflared proxy-dns command will be removed starting February 2, 2026**

Starting February 2, 2026, the `cloudflared proxy-dns` command will be removed from all new `cloudflared` [releases](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/downloads/).

This change is being made to enhance security and address a potential vulnerability in an underlying DNS library. This vulnerability is specific to the `proxy-dns` command and does not affect any other `cloudflared` features, such as the core [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) service.

The `proxy-dns` command, which runs a client-side [DNS-over-HTTPS (DoH)](https://developers.cloudflare.com/1.1.1.1/encryption/dns-over-https/) proxy, has been an officially undocumented feature for several years. This functionality is fully and securely supported by our actively developed products.

Versions of `cloudflared` released before this date will not be affected and will continue to operate. However, note that our [official support policy](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/downloads/#deprecated-releases) for any `cloudflared` release is one year from its release date.

#### Migration paths

We strongly advise users of this undocumented feature to migrate to one of the following officially supported solutions before February 2, 2026, to continue benefiting from secure [DNS-over-HTTPS](https://developers.cloudflare.com/1.1.1.1/encryption/dns-over-https/).

#### End-user devices

The preferred method for enabling DNS-over-HTTPS on user devices is the [Cloudflare WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/). The WARP client automatically secures and proxies all DNS traffic from your device, integrating it with your organization's [Zero Trust policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) and [posture checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/).

#### Servers, routers, and IoT devices

For scenarios where installing a client on every device is not possible (such as servers, routers, or IoT devices), we recommend using the [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/).

Instead of running `cloudflared proxy-dns` on a machine, you can install the WARP Connector on a single Linux host within your private network. This connector will act as a gateway, securely routing all DNS and network traffic from your [entire subnet](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/) to Cloudflare for [filtering and logging](https://developers.cloudflare.com/cloudflare-one/traffic-policies/).

## 2025-11-06

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Applications to be remapped to the new categories**

We have previously added new application categories to better reflect their content and improve HTTP traffic management: refer to [Changelog](https://developers.cloudflare.com/cloudflare-one/changelog/gateway/#2025-10-28). While the new categories are live now, we want to ensure you have ample time to review and adjust any existing rules you have configured against old categories. The remapping of existing applications into these new categories will be completed by January 30, 2026. This timeline allows you a dedicated period to:

* Review the new category structure.
* Identify any policies you have that target the older categories.
* Adjust your rules to reference the new, more precise categories before the old mappings change. Once the applications have been fully remapped by January 30, 2026, you might observe some changes in the traffic being mitigated or allowed by your existing policies. We encourage you to use the intervening time to prepare for a smooth transition.

**Applications being remappedd**

| Application Name | Existing Category | New Category |
| - | - | - |
| Google Photos | File Sharing | Photography & Graphic Design |
| Flickr | File Sharing | Photography & Graphic Design |
| ADP | Human Resources | Business |
| Greenhouse | Human Resources | Business |
| myCigna | Human Resources | Health & Fitness |
| UnitedHealthcare | Human Resources | Health & Fitness |
| ZipRecruiter | Human Resources | Business |
| Amazon Business | Human Resources | Business |
| Jobcenter | Human Resources | Business |
| Jobsuche | Human Resources | Business |
| Zenjob | Human Resources | Business |
| DocuSign | Legal | Business |
| Postident | Legal | Business |
| Adobe Creative Cloud | Productivity | Photography & Graphic Design |
| Airtable | Productivity | Development |
| Autodesk Fusion360 | Productivity | IT Management |
| Coursera | Productivity | Education |
| Microsoft Power BI | Productivity | Business |
| Tableau | Productivity | Business |
| Duolingo | Productivity | Education |
| Adobe Reader | Productivity | Business |
| AnpiReport | Productivity | Travel |
| ビズリーチ | Productivity | Business |
| doda (デューダ) | Productivity | Business |
| 求人ボックス | Productivity | Business |
| マイナビ2026 | Productivity | Business |
| Power Apps | Productivity | Business |
| RECRUIT AGENT | Productivity | Business |
| シフトボード | Productivity | Business |
| スタンバイ | Productivity | Business |
| Doctolib | Productivity | Health & Fitness |
| Miro | Productivity | Photography & Graphic Design |
| MyFitnessPal | Productivity | Health & Fitness |
| Sentry Mobile | Productivity | Travel |
| Slido | Productivity | Photography & Graphic Design |
| Arista Networks | Productivity | IT Management |
| Atlassian | Productivity | Business |
| CoderPad | Productivity | Business |
| eAgreements | Productivity | Business |
| Vmware | Productivity | IT Management |
| Vmware Vcenter | Productivity | IT Management |
| AWS Skill Builder | Productivity | Education |
| Microsoft Office 365 (GCC) | Productivity | Business |
| Microsoft Exchange Online (GCC) | Productivity | Business |
| Canva | Sales & Marketing | Photography & Graphic Design |
| Instacart | Shopping | Food & Drink |
| Wawa | Shopping | Food & Drink |
| McDonald's | Shopping | Food & Drink |
| Vrbo | Shopping | Travel |
| American Airlines | Shopping | Travel |
| Booking.com | Shopping | Travel |
| Ticketmaster | Shopping | Entertainment & Events |
| Airbnb | Shopping | Travel |
| DoorDash | Shopping | Food & Drink |
| Expedia | Shopping | Travel |
| EasyPark | Shopping | Travel |
| UEFA Tickets | Shopping | Entertainment & Events |
| DHL Express | Shopping | Business |
| UPS | Shopping | Business |

For more information on creating HTTP policies, refer to [Applications and app types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/).

## 2025-10-28

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Access private hostname applications support all ports/protocols**

[Cloudflare Access for private hostname applications](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/self-hosted-private-app/) can now secure traffic on all ports and protocols.

Previously, applying Zero Trust policies to private applications required the application to use HTTPS on port `443` and support Server Name Indicator (SNI).

This update removes that limitation. As long as the application is reachable via a Cloudflare off-ramp, you can now enforce your critical security controls — like single sign-on (SSO), MFA, device posture, and variable session lengths — to any private application. This allows you to extend Zero Trust security to services like SSH, RDP, internal databases, and other non-HTTPS applications.

![Example private application on non-443 port](https://developers.cloudflare.com/_astro/internal_private_app_any_port.DNXnEy0u_1ijFvb.webp)

For example, you can now create a self-hosted application in Access for `ssh.testapp.local` running on port `22`. You can then build a policy that only allows engineers in your organization to connect after they pass an SSO/MFA check and are using a corporate device.

This feature is generally available across all plans.

## 2025-10-28

[CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

**CASB introduces new granular roles**

Cloudflare CASB (Cloud Access Security Broker) now supports two new granular roles to provide more precise access control for your security teams:

* **Cloudflare CASB Read:** Provides read-only access to view CASB findings and dashboards. This role is ideal for security analysts, compliance auditors, or team members who need visibility without modification rights.
* **Cloudflare CASB:** Provides full administrative access to configure and manage all aspects of the CASB product.

These new roles help you better enforce the principle of least privilege. You can now grant specific members access to CASB security findings without assigning them broader permissions, such as the **Super Administrator** or **Administrator** roles.

To enable [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/), scans in CASB, account members will need the **Cloudflare Zero Trust** role.

You can find these new roles when inviting members or creating API tokens in the Cloudflare dashboard under **Manage Account** > **Members**.

To learn more about managing roles and permissions, refer to the [Manage account members and roles documentation](https://developers.cloudflare.com/fundamentals/manage-members/roles/).

## 2025-10-28

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**New Application Categories added for HTTP Traffic Management**

To give you precision and flexibility while creating policies to block unwanted traffic, we are introducing new, more granular application categories in the Gateway product.

We have added the following categories to provide more precise organization and allow for finer-grained policy creation, designed around how users interact with different types of applications:

* Business
* Education
* Entertainment & Events
* Food & Drink
* Health & Fitness
* Lifestyle
* Navigation
* Photography & Graphic Design
* Travel

The new categories are live now, but we are providing a transition period for existing applications to be fully remapped to these new categories.

The full remapping will be completed by January 30, 2026.

We encourage you to use this time to:

* Review the new category structure.
* Identify and adjust any existing HTTP policies that reference older categories to ensure a smooth transition.

For more information on creating HTTP policies, refer to [Applications and app types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/).

## 2025-10-20

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Schedule DNS policies from the UI**

Admins can now create [scheduled DNS policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/timed-policies/) directly from the Zero Trust dashboard, without using the API. You can configure policies to be active during specific, recurring times, such as blocking social media during business hours or gaming sites on school nights.

* **Preset Schedules**: Use built-in templates for common scenarios like Business Hours, School Days, Weekends, and more.
* **Custom Schedules**: Define your own schedule with specific days and up to three non-overlapping time ranges per day.
* **Timezone Control**: Choose to enforce a schedule in a specific timezone (for example, US Eastern) or based on the local time of each user.
* **Combined with Duration**: Policies can have both a schedule and a duration. If both are set, the duration's expiration takes precedence.

You can see the flow in the demo GIF:

![Schedule DNS policies demo](https://developers.cloudflare.com/_astro/gateway-dns-scheduled-policies-ui.Cf4l1OTE_29xeRx.webp)

This update makes time-based DNS policies accessible to all Gateway customers, removing the technical barrier of the API.

## 2025-10-17

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**On-Demand Security Report**

You can now generate on-demand security reports directly from the Cloudflare dashboard. This new feature provides a comprehensive overview of your email security posture, making it easier than ever to demonstrate the value of Cloudflare’s Email security to executives and other decision makers.

These reports offer several key benefits:

* **Executive Summary:** Quickly view the performance of Email security with a high-level executive summary.
* **Actionable Insights:** Dive deep into trend data, breakdowns of threat types, and analysis of top targets to identify and address vulnerabilities.
* **Configuration Transparency:** Gain a clear view of your policy, submission, and domain configurations to ensure optimal setup.

![Report](https://developers.cloudflare.com/_astro/report.CbkPa8Jt_BRc7y.webp)

This feature is available across the following Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-10-16

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.9.173.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes, improvements, and new features including Path Maximum Transmission Unit Discovery (PMTUD). With PMTUD enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to debug connectivity issues.

**Changes and improvements**

* Improvements for [Windows multi-user](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/windows-multiuser/) to maintain the [global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) state when switching between users.
* The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to debug connectivity issues.
* Deleting registrations no longer returns an error when succeeding.
* Path Maximum Transmission Unit Discovery (PMTUD) is now used to discover the effective MTU of the connection. This allows the client to improve connection performance optimized for the current network.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-10-16

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.9.173.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes, improvements, and new features including Path Maximum Transmission Unit Discovery (PMTUD). With PMTUD enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to debug connectivity issues.

**Changes and improvements**

* The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to debug connectivity issues.
* Deleting registrations no longer returns an error when succeeding.
* Path Maximum Transmission Unit Discovery (PMTUD) is now used to discover the effective MTU of the connection. This allows the client to improve connection performance optimized for the current network.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-10-10

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**New domain categories added**

We have added three new domain categories under the Technology parent category, to better reflect online content and improve DNS filtering.

**New categories added**

| Parent ID | Parent Name | Category ID | Category Name |
| - | - | - | - |
| 26 | Technology | 194 | Keep Awake Software |
| 26 | Technology | 192 | Remote Access |
| 26 | Technology | 193 | Shareware/Freeware |

Refer to [Gateway domain categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) to learn more.

## 2025-10-07

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.8.779.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements including an updated public key for Linux packages. The public key must be updated if it was installed before September 12, 2025 to ensure the repository remains functional after December 4, 2025. Instructions to make this update are available at [pkg.cloudflareclient.com](https://pkg.cloudflareclient.com/).

**Changes and improvements**

* The MASQUE protocol is now the only protocol that can use [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode). If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new WARP mode or switch to the MASQUE protocol. Otherwise, all devices matching the profile will lose connectivity.

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-10-07

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.8.779.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements including enhancements to Proxy mode for even faster resolution.

**Changes and improvements**

* The MASQUE protocol is now the only protocol that can use [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode). If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new WARP mode or switch to the MASQUE protocol. Otherwise, all devices matching the profile will lose connectivity.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-10-07

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.8.779.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements including enhancements to Proxy mode for even faster resolution.

**Changes and improvements**

* The MASQUE protocol is now the only protocol that can use [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode). If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new WARP mode or switch to the MASQUE protocol. Otherwise, all devices matching the profile will lose connectivity.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-10-01

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**Expanded File Type Controls for Executables and Disk Images**

You can now enhance your security posture by blocking additional application installer and disk image file types with Cloudflare Gateway. Preventing the download of unauthorized software packages is a critical step in securing endpoints from malware and unwanted applications.

We have expanded Gateway's file type controls to include:

* Apple Disk Image (dmg)
* Microsoft Software Installer (msix, appx)
* Apple Software Package (pkg)

You can find these new options within the [*Upload File Types* and *Download File Types* selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#download-and-upload-file-types) when creating or editing an HTTP policy. The file types are categorized as follows:

* **System**: *Apple Disk Image (dmg)*
* **Executable**: *Microsoft Software Installer (msix)*, *Microsoft Software Installer (appx)*, *Apple Software Package (pkg)*

To ensure these file types are blocked effectively, please note the following behaviors:

* DMG: Due to their file structure, DMG files are blocked at the very end of the transfer. A user's download may appear to progress but will fail at the last moment, preventing the browser from saving the file.
* MSIX: To comprehensively block Microsoft Software Installers, you should also include the file type *Unscannable*. MSIX files larger than 100 MB are identified as Unscannable ZIP files during inspection.

To get started, go to your HTTP policies in Zero Trust. For a full list of file types, refer to [supported file types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#supported-file-types).

## 2025-09-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.7.176.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* MASQUE is now the default [tunnel protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol) for all new WARP device profiles.
* Improvement to limit idle connections in [Gateway with DoH mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-doh) to avoid unnecessary resource usage that can lead to DoH requests not resolving.
* Improvement to maintain TCP connections to reduce interruptions in long-lived connections such as RDP or SSH.
* Improvements to maintain [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) settings when [switching between organizations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/switch-organizations/#switch-organizations-in-warp).
* Improvements to maintain client connectivity during network changes.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-09-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.7.176.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* Fixed a bug preventing the `warp-diag captive-portal` command from running successfully due to the client not parsing SSID on macOS.
* Improvements to maintain [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) settings when [switching between organizations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/switch-organizations/#switch-organizations-in-warp).
* MASQUE is now the default [tunnel protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol) for all new WARP device profiles.
* Improvement to limit idle connections in [Gateway with DoH mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-doh) to avoid unnecessary resource usage that can lead to DoH requests not resolving.
* Improvements to maintain client connectivity during network changes.
* The WARP client now supports macOS Tahoe (version 26.0).

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-09-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.7.176.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements including an updated public key for Linux packages. The public key must be updated if it was installed before September 12, 2025 to ensure the repository remains functional after December 4, 2025. Instructions to make this update are available at [pkg.cloudflareclient.com](https://pkg.cloudflareclient.com/).

**Changes and improvements**

* MASQUE is now the default [tunnel protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol) for all new WARP device profiles.
* Improvement to limit idle connections in [Gateway with DoH mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-doh) to avoid unnecessary resource usage that can lead to DoH requests not resolving.
* Improvements to maintain [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) settings when [switching between organizations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/switch-organizations/#switch-organizations-in-warp).
* Improvements to maintain client connectivity during network changes.

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-09-30

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Application granular controls for operations in SaaS applications**

Gateway users can now apply granular controls to their file sharing and AI chat applications through [HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies).

The new feature offers two methods of controlling SaaS applications:

* **Application Controls** are curated groupings of Operations which provide an easy way for users to achieve a specific outcome. Application Controls may include *Upload*, *Download*, *Prompt*, *Voice*, and *Share* depending on the application.
* **Operations** are controls aligned to the most granular action a user can take. This provides a fine-grained approach to enforcing policy and generally aligns to the SaaS providers API specifications in naming and function.

Get started using [Application Granular Controls](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/granular-controls) and refer to the list of [supported applications](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/granular-controls/#compatible-applications).

## 2025-09-25

[Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**Refine DLP Scans with New Body Phase Selector**

You can now more precisely control your HTTP DLP policies by specifying whether to scan the request or response body, helping to reduce false positives and target specific data flows.

In the Gateway HTTP policy builder, you will find a new selector called *Body Phase*. This allows you to define the direction of traffic the DLP engine will inspect:

* *Request Body*: Scans data sent from a user's machine to an upstream service. This is ideal for monitoring data uploads, form submissions, or other user-initiated data exfiltration attempts.
* *Response Body*: Scans data sent to a user's machine from an upstream service. Use this to inspect file downloads and website content for sensitive data.

For example, consider a policy that blocks Social Security Numbers (SSNs). Previously, this policy might trigger when a user visits a website that contains example SSNs in its content (the response body). Now, by setting the **Body Phase** to *Request Body*, the policy will only trigger if the user attempts to upload or submit an SSN, ignoring the content of the web page itself.

All policies without this selector will continue to scan both request and response bodies to ensure continued protection.

For more information, refer to [Gateway HTTP policy selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#body-phase/).

## 2025-09-23

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Invalid Submissions Feedback**

Email security relies on your submissions to continuously improve our detection models. However, we often receive submissions in formats that cannot be ingested, such as incomplete EMLs, screenshots, or text files.

To ensure all customer feedback is actionable, we have launched two new features to manage invalid submissions sent to our team and user [submission aliases](https://developers.cloudflare.com/cloudflare-one/email-security/settings/phish-submissions/submission-addresses/):

* **Email Notifications:** We now automatically notify users by email when they provide an invalid submission, educating them on the correct format. To disable notifications, go to **[Settings](https://one.dash.cloudflare.com/?to=/:account/email-security/settings)** > **Invalid submission emails** and turn the feature off.

![EmailSec-Invalid-Submissions-Toggle](https://developers.cloudflare.com/_astro/EmailSec-Invalid-Submissions-Toggle.DXjbR6aX_Z1aqqxR.webp)

* **Invalid Submission dashboard:** You can quickly identify which users need education to provide valid submissions so Cloudflare can provide continuous protection.

![EmailSec-Invalid-Submissions-Dashboard](https://developers.cloudflare.com/_astro/EmailSec-Invalid-Submissions-Dashboard.zuf1on2n_Z1M2oP7.webp)

Learn more about this feature on [invalid submissions](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/invalid-submissions/).

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-09-22

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Access Remote Desktop Protocol (RDP) destinations securely from your browser — now generally available!**

[Browser-based RDP](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/) with [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) is now generally available for all Cloudflare customers. It enables secure, remote Windows server access without VPNs or RDP clients.

Since we announced our [open beta](https://developers.cloudflare.com/changelog/access/#2025-06-30), we've made a few improvements:

* Support for targets with IPv6.
* Support for [Magic WAN](https://developers.cloudflare.com/magic-wan/) and [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) as on-ramps.
* More robust error messaging on the login page to help you if you encounter an issue.
* Worldwide keyboard support. Whether your day-to-day is in Portuguese, Chinese, or something in between, your browser-based RDP experience will look and feel exactly like you are using a desktop RDP client.
* Cleaned up some other miscellaneous issues, including but not limited to enhanced support for Entra ID accounts and support for usernames with spaces, quotes, and special characters.

As a refresher, here are some benefits browser-based RDP provides:

* **Control how users authenticate to internal RDP resources** with single sign-on (SSO), multi-factor authentication (MFA), and granular access policies.
* **Record who is accessing which servers and when** to support regulatory compliance requirements and to gain greater visibility in the event of a security event.
* **Eliminate the need to install and manage software on user devices**. You will only need a web browser.
* **Reduce your attack surface** by keeping your RDP servers off the public Internet and protecting them from common threats like credential stuffing or brute-force attacks.

![Example of a browser-based RDP Access application](https://developers.cloudflare.com/_astro/browser-based-rdp-access-app.BNXce1JL_1NEtce.webp)

To get started, refer to [Connect to RDP in a browser](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/).

## 2025-09-18

[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

**Connect and secure any private or public app by hostname, not IP — with hostname routing for Cloudflare Tunnel**

You can now route private traffic to [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) based on a hostname or domain, moving beyond the limitations of IP-based routing. This new capability is **free for all Cloudflare One customers**.

Previously, Tunnel routes could only be defined by IP address or [CIDR range](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/connect-cidr/). This created a challenge for modern applications with dynamic or ephemeral IP addresses, often forcing administrators to maintain complex and brittle IP lists.

![Hostname-based routing in Cloudflare Tunnel](https://developers.cloudflare.com/_astro/tunnel-hostname-routing.DSi8MP_7_1xE3pm.webp)

**What’s new:**

* **Hostname & Domain Routing**: Create routes for individual hostnames (e.g., `payroll.acme.local`) or entire domains (e.g., `*.acme.local`) and direct their traffic to a specific Tunnel.
* **Simplified Zero Trust Policies**: Build resilient policies in Cloudflare Access and Gateway using stable hostnames, making it dramatically easier to apply per-resource authorization for your private applications.
* **Precise Egress Control**: Route traffic for public hostnames (e.g., `bank.example.com`) through a specific Tunnel to enforce a dedicated source IP, solving the IP allowlist problem for third-party services.
* **No More IP Lists**: This feature makes the workaround of maintaining dynamic IP Lists for Tunnel connections obsolete.

Get started in the Tunnels section of the Zero Trust dashboard with your first [private hostname](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/connect-private-hostname/) or [public hostname](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/egress-cloudflared/) route.

Learn more in our [blog post](https://blog.cloudflare.com/tunnel-hostname-routing/).

## 2025-09-16

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New AI-Enabled Search for Zero Trust Dashboard**

Zero Trust Dashboard has a brand new, AI-powered search functionality. You can search your account by resources (applications, policies, device profiles, settings, etc.), pages, products, and more.

![Example search results in the Zero Trust dashboard](https://developers.cloudflare.com/_astro/searchexample.Di8yS8ju_Z1EfFaP.webp)

**Ask Cloudy** — You can also ask Cloudy, our AI agent, questions about Cloudflare Zero Trust. Cloudy is trained on our developer documentation and implementation guides, so it can tell you how to configure functionality, best practices, and can make recommendations.

Cloudy can then stay open with you as you move between pages to build configuration or answer more questions.

**Find Recents** — Recent searches and Cloudy questions also have a new tab under Zero Trust Overview.

## 2025-09-11

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Regional Email Processing for Germany, India, or Australia**

We’re excited to announce that Email security customers can now choose their preferred mail processing location directly from the UI when onboarding a domain. This feature is available for the following onboarding methods: **MX**, **BCC**, and **Journaling**.

#### What’s new

Customers can now select where their email is processed. The following regions are supported:

* **Germany**
* **India**
* **Australia**

Global processing remains the default option, providing flexibility to meet both compliance requirements or operational preferences.

#### How to use it

When onboarding a domain with MX, BCC, or Journaling:

1. Select the desired processing location (Germany, India, or Australia).
2. The UI will display updated processing addresses specific to that region.
3. For MX onboarding, if your domain is managed by Cloudflare, you can automatically update MX records directly from the UI.

#### Availability

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

#### What’s next

We’re expanding the list of processing locations to match our [Data Localization Suite (DLS)](https://developers.cloudflare.com/data-localization/) footprint, giving customers the broadest set of regional options in the market without the complexity of self-hosting.

## 2025-09-11

[Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Magic WAN ](https://developers.cloudflare.com/magic-wan/)[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

**DNS filtering for private network onramps**

[Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/#dns-filtering) and [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/#configure-dns-resolver-on-devices) users can now securely route their DNS traffic to the Gateway resolver without exposing traffic to the public Internet.

Routing DNS traffic to the Gateway resolver allows DNS resolution and filtering for traffic coming from private networks while preserving source internal IP visibility. This ensures Magic WAN users have full integration with our Cloudflare One features, including [Internal DNS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/#internal-dns) and [hostname-based policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

To configure DNS filtering, change your Magic WAN or WARP Connector DNS settings to use Cloudflare's shared resolver IPs, `172.64.36.1` and `172.64.36.2`. Once you configure DNS resolution and filtering, you can use *Source Internal IP* as a traffic selector in your [resolver policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/) for routing private DNS traffic to your [Internal DNS](https://developers.cloudflare.com/dns/internal-dns/).

## 2025-09-10

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.7.106.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements including enhancements to [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode) for even faster resolution. The MASQUE protocol is now the only protocol that can use Proxy mode. If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new [WARP mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) or all devices matching the profile will lose connectivity.

**Changes and improvements**

* Enhancements to [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode) for even faster resolution. The MASQUE protocol is now the only protocol that can use Proxy mode. If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new [WARP mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) or all devices matching the profile will lose connectivity.
* Improvement to keep TCP connections up the first time WARP connects on devices so that remote desktop sessions (such as RDP or SSH) continue to work.
* Improvements to maintain Global WARP Override settings when switching between organization configurations.
* The [MASQUE protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol) is now the default protocol for all new WARP device profiles.
* Improvement to limit idle connections in DoH mode to avoid unnecessary resource usage that can lead to DoH requests not resolving.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about Win32/ClickFix.ABA being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-09-10

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.7.106.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements including enhancements to [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode) for even faster resolution. The MASQUE protocol is now the only protocol that can use Proxy mode. If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new [WARP mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) or all devices matching the profile will lose connectivity.

**Changes and improvements**

* Enhancements to [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode) for even faster resolution. The MASQUE protocol is now the only protocol that can use Proxy mode. If you previously configured a device profile to use Proxy mode with Wireguard, you will need to select a new [WARP mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) or all devices matching the profile will lose connectivity.
* Fixed a bug preventing the `warp-diag captive-portal` command from running successfully due to the client not parsing SSID on macOS.
* Improvements to maintain Global WARP Override settings when switching between organization configurations.
* The [MASQUE protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol) is now the default protocol for all new WARP device profiles.
* Improvement to limit idle connections in DoH mode to avoid unnecessary resource usage that can lead to DoH requests not resolving.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-09-08

[Magic WAN](https://developers.cloudflare.com/magic-wan/)

**Custom IKE ID for IPsec Tunnels**

Now, Magic WAN customers can configure a custom IKE ID for their IPsec tunnels. Customers that are using Magic WAN and a VeloCloud SD-WAN device together can utilize this new feature to create a high availability configuration.

This feature is available via API only. Customers can read the Magic WAN documentation to learn more about the [Custom IKE ID feature and the API call to configure it](https://developers.cloudflare.com/magic-wan/configuration/common-settings/custom-ike-id-ipsec/).

## 2025-09-05

[Magic WAN](https://developers.cloudflare.com/magic-wan/)

**Bidirectional tunnel health checks are compatible with all Magic on-ramps**

All bidirectional tunnel health check return packets are accepted by any Magic on-ramp.

Previously, when a Magic tunnel had a bidirectional health check configured, the bidirectional health check would pass when the return packets came back to Cloudflare over the same tunnel that was traversed by the forward packets.

There are SD-WAN devices, like VeloCloud, that do not offer controls to steer traffic over one tunnel versus another in a high availability tunnel configuration.

Now, when a Magic tunnel has a bidirectional health check configured, the bidirectional health check will pass when the return packet traverses over any tunnel in a high availability configuration.

## 2025-09-02

[Cloudflare One ](https://developers.cloudflare.com/cloudflare-one/)[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

**Cloudflare Tunnel and Networks API will no longer return deleted resources by default starting December 1, 2025**

Starting **December 1, 2025**, list endpoints for the [Cloudflare Tunnel API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/) and [Zero Trust Networks API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/) will no longer return deleted tunnels, routes, subnets and virtual networks by default. This change makes the API behavior more intuitive by only returning active resources unless otherwise specified.

No action is required if you already explicitly set `is_deleted=false` or if you only need to list active resources.

This change affects the following API endpoints:

* List all tunnels: [`GET /accounts/{account_id}/tunnels`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/methods/list/)
* List [Cloudflare Tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/): [`GET /accounts/{account_id}/cfd_tunnel`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/subresources/cloudflared/methods/list/)
* List [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) tunnels: [`GET /accounts/{account_id}/warp_connector`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/subresources/warp_connector/methods/list/)
* List tunnel routes: [`GET /accounts/{account_id}/teamnet/routes`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/routes/methods/list/)
* List subnets: [`GET /accounts/{account_id}/zerotrust/subnets`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/subnets/methods/list/)
* List virtual networks: [`GET /accounts/{account_id}/teamnet/virtual_networks`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/virtual_networks/methods/list/)

#### What is changing?

The default behavior of the `is_deleted` query parameter will be updated.

| Scenario | Previous behavior (before December 1, 2025) | New behavior (from December 1, 2025) |
| - | - | - |
| `is_deleted` parameter is omitted | Returns **active & deleted** tunnels, routes, subnets and virtual networks | Returns **only active** tunnels, routes, subnets and virtual networks |

#### Action required

If you need to retrieve deleted (or all) resources, please update your API calls to explicitly include the `is_deleted` parameter before **December 1, 2025**.

To get a list of only deleted resources, you must now explicitly add the `is_deleted=true` query parameter to your request:

```bash
# Example: Get ONLY deleted Tunnels
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/tunnels?is_deleted=true" \
     -H "Authorization: Bearer $API_TOKEN"


# Example: Get ONLY deleted Virtual Networks
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/teamnet/virtual_networks?is_deleted=true" \
     -H "Authorization: Bearer $API_TOKEN"
```

Following this change, retrieving a complete list of both active and deleted resources will require two separate API calls: one to get active items (by omitting the parameter or using `is_deleted=false`) and one to get deleted items (`is_deleted=true`).

#### Why we’re making this change

This update is based on user feedback and aims to:

* **Create a more intuitive default:** Aligning with common API design principles where list operations return only active resources by default.
* **Reduce unexpected results:** Prevents users from accidentally operating on deleted resources that were returned unexpectedly.
* **Improve performance:** For most users, the default query result will now be smaller and more relevant.

To learn more, please visit the [Cloudflare Tunnel API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/) and [Zero Trust Networks API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/) documentation.

## 2025-09-01

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Updated Email security roles**

To provide more granular controls, we refined the [existing roles](https://developers.cloudflare.com/cloudflare-one/roles-permissions/#email-security-roles) for Email security and launched a new Email security role as well.

All Email security roles no longer have read or write access to any of the other Zero Trust products:

* **Email Configuration Admin**
* **Email Integration Admin**
* **Email security Read Only**
* **Email security Analyst**
* **Email security Policy Admin**
* **Email security Reporting**

To configure [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/email-security/outbound-dlp/) or [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/#set-up-clientless-web-isolation), you now need to be an admin for the Zero Trust dashboard with the **Cloudflare Zero Trust** role.

Also through customer feedback, we have created a new additive role to allow **Email security Analyst** to create, edit, and delete Email security policies, without needing to provide access via the **Email Configuration Admin** role. This role is called **Email security Policy Admin**, which can read all settings, but has write access to [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/allow-policies/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/), and [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/blocked-senders/).

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-08-29

[Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/)

**DEX MCP Server**

[Digital Experience Monitoring (DEX)](https://developers.cloudflare.com/cloudflare-one/insights/dex/) provides visibility into device connectivity and performance across your Cloudflare SASE deployment.

We've released an MCP server [(Model Context Protocol)](https://cloudflare.com/learning/ai/what-is-model-context-protocol-mcp/) for DEX.

The DEX MCP server is an AI tool that allows customers to ask a question like, "Show me the connectivity and performance metrics for the device used by carly‌@acme.com", and receive an answer that contains data from the DEX API.

Any Cloudflare One customer using a Free, PayGo, or Enterprise account can access the DEX MCP Server. This feature is available to everyone.

Customers can test the new DEX MCP server in less than one minute. To learn more, read the [DEX MCP server documentation](https://developers.cloudflare.com/cloudflare-one/insights/dex/dex-mcp-server/).

## 2025-08-29

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**Cloudflare One WARP Diagnostic AI Analyzer**

We're excited to share a new AI feature, the [WARP diagnostic analyzer](https://blog.cloudflare.com/AI-troubleshoot-warp-and-network-connectivity-issues/), to help you troubleshoot and resolve WARP connectivity issues faster. This beta feature is now available in the [Zero Trust dashboard](https://one.dash.cloudflare.com/) to all users. The AI analyzer makes it easier for you to identify the root cause of client connectivity issues by parsing [remote captures](https://developers.cloudflare.com/cloudflare-one/insights/dex/remote-captures/#start-a-remote-capture) of [WARP diagnostic logs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/warp-logs/#warp-diag-logs). The WARP diagnostic analyzer provides a summary of impact that may be experienced on the device, lists notable events that may contribute to performance issues, and recommended troubleshooting steps and articles to help you resolve these issues. Refer to [WARP diagnostics analyzer (beta)](https://developers.cloudflare.com/cloudflare-one/insights/dex/remote-captures/#warp-diagnostics-analyzer-beta) to learn more about how to maximize using the WARP diagnostic analyzer to troubleshoot the WARP client.

## 2025-08-27

[Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**Shadow IT - SaaS analytics dashboard**

Zero Trust has significantly upgraded its **Shadow IT analytics**, providing you with unprecedented visibility into your organizations use of SaaS tools. With this dashboard, you can review who is using an application and volumes of data transfer to the application.

You can review these metrics against application type, such as Artificial Intelligence or Social Media. You can also mark applications with an approval status, including **Unreviewed**, **In Review**, **Approved**, and **Unapproved** designating how they can be used in your organization.

![Cloudflare One Analytics Dashboards](https://developers.cloudflare.com/_astro/shadow-it-analytics.BLNnG72w_eGLA5.webp)

These application statuses can also be used in Gateway HTTP policies, so you can block, isolate, limit uploads and downloads, and more based on the application status.

Both the analytics and policies are accessible in the Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/), empowering organizations with better visibility and control.

## 2025-08-26

[CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

**New CASB integrations for ChatGPT, Claude, and Gemini**

[Cloudflare CASB](https://www.cloudflare.com/zero-trust/products/casb/) now supports three of the most widely used GenAI platforms — **OpenAI ChatGPT**, **Anthropic Claude**, and **Google Gemini**. These API-based integrations give security teams agentless visibility into posture, data, and compliance risks across their organization’s use of generative AI.

![Cloudflare CASB showing selection of new findings for ChatGPT, Claude, and Gemini integrations.](https://developers.cloudflare.com/_astro/casb-ai-integrations-preview.B-zsSA1P_Z1CkbtH.webp)

#### Key capabilities

* **Agentless connections** — connect ChatGPT, Claude, and Gemini tenants via API; no endpoint software required
* **Posture management** — detect insecure settings and misconfigurations that could lead to data exposure
* **DLP detection** — identify sensitive data in uploaded chat attachments or files
* **GenAI-specific insights** — surface risks unique to each provider’s capabilities

#### Learn more

* [ChatGPT integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/openai/)
* [Claude integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/anthropic/)
* [Gemini integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/google-workspace/gemini/)

These integrations are available to all Cloudflare One customers today.

## 2025-08-26

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Manage and restrict access to internal MCP servers with Cloudflare Access**

You can now control who within your organization has access to internal MCP servers, by putting internal MCP servers behind [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/).

[Self-hosted applications](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/linked-apps/) in Cloudflare Access now support OAuth for MCP server authentication. This allows Cloudflare to delegate access from any self-hosted application to an MCP server via OAuth. The OAuth access token authorizes the MCP server to make requests to your self-hosted applications on behalf of the authorized user, using that user's specific permissions and scopes.

For example, if you have an MCP server designed for internal use within your organization, you can configure Access policies to ensure that only authorized users can access it, regardless of which MCP client they use. Support for internal, self-hosted MCP servers also works with MCP server portals, allowing you to provide a single MCP endpoint for multiple MCP servers. For more on MCP server portals, read the [blog post](https://blog.cloudflare.com/zero-trust-mcp-server-portals/) on the Cloudflare Blog.

## 2025-08-26

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**MCP server portals**\
![MCP server portal](https://developers.cloudflare.com/_astro/mcp-server-portal.BOKqTCoI_ZIxF0P.webp)

An [MCP server portal](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/mcp-portals/) centralizes multiple Model Context Protocol (MCP) servers onto a single HTTP endpoint. Key benefits include:

* **Streamlined access to multiple MCP servers**: MCP server portals support both unauthenticated MCP servers as well as MCP servers secured using any third-party or custom OAuth provider. Users log in to the portal URL through Cloudflare Access and are prompted to authenticate separately to each server that requires OAuth.
* **Customized tools per portal**: Admins can tailor an MCP portal to a particular use case by choosing the specific tools and prompt templates that they want to make available to users through the portal. This allows users to access a curated set of tools and prompts — the less external context exposed to the AI model, the better the AI responses tend to be.
* **Observability**: Once the user's AI agent is connected to the portal, Cloudflare Access logs the indiviudal requests made using the tools in the portal.

This is available in an open beta for all customers across all plans! For more information check out our [blog](https://blog.cloudflare.com/zero-trust-mcp-server-portals/) for this release.

## 2025-08-25

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**New DLP topic based detection entries for AI prompt protection**

You now have access to a comprehensive suite of capabilities to secure your organization's use of generative AI. AI prompt protection introduces four key features that work together to provide deep visibility and granular control.

1. **Prompt Detection for AI Applications**

DLP can now natively detect and inspect user prompts submitted to popular AI applications, including **Google Gemini**, **ChatGPT**, **Claude**, and **Perplexity**.

1. **Prompt Analysis and Topic Classification**

Our DLP engine performs deep analysis on each prompt, applying [topic classification](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#ai-prompt-topics). These topics are grouped into two evaluation categories:

* **Content:** PII, Source Code, Credentials and Secrets, Financial Information, and Customer Data.

* **Intent:** Jailbreak attempts, requests for malicious code, or attempts to extract PII.

To help you apply these topics quickly, we have also released five new predefined profiles (for example, AI Prompt: AI Security, AI Prompt: PII) that bundle these new topics.

![DLP](https://developers.cloudflare.com/_astro/ai-prompt-detection-entry.4QmdkAuv_1OGLqX.webp)

1. **Granular Guardrails**

   You can now build guardrails using Gateway HTTP policies with [application granular controls](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#application-granular-controls). Apply a DLP profile containing an [AI prompt topic detection](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#ai-prompt-topics) to individual AI applications (for example, `ChatGPT`) and specific user actions (for example, `SendPrompt`) to block sensitive prompts.

   ![DLP](https://developers.cloudflare.com/_astro/ai-prompt-policy.CF3H2rbK_Z1leRrd.webp)

2. **Full Prompt Logging**

   To aid in incident investigation, an optional setting in your Gateway policy allows you to [capture prompt logs](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-generative-ai-prompt-content) to store the full interaction of prompts that trigger a policy match. To make investigations easier, logs can be filtered by `conversation_id`, allowing you to reconstruct the full context of an interaction that led to a policy violation.

   ![DLP](https://developers.cloudflare.com/_astro/ai-prompt-log.ywQDc5qN_285cvc.webp)

AI prompt protection is now available in open beta. To learn more about it, read the [blog](https://blog.cloudflare.com/ai-prompt-protection/#closing-the-loop-logging) or refer to [AI prompt topics](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#ai-prompt-topics).

## 2025-08-21

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.6.1400.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains a hotfix for pre-login for multi-user for the 2025.6.1135.0 release.

**Changes and improvements**

* Fixes an issue where new pre-login registrations were not being properly created.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about Win32/ClickFix.ABA being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, please reconnect the WARP client by toggling off and back on.

## 2025-08-21

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Gateway BYOIP Dedicated Egress IPs now available.**

Enterprise Gateway users can now use Bring Your Own IP (BYOIP) for dedicated egress IPs.

Admins can now onboard and use their own IPv4 or IPv6 prefixes to egress traffic from Cloudflare, delivering greater control, flexibility, and compliance for network traffic.

Get started by following the [BYOIP onboarding process](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/#bring-your-own-ip-address-byoip). Once your IPs are onboarded, go to **Gateway** > **Egress policies** and select or create an egress policy. In **Select an egress IP**, choose *Use dedicated egress IPs (Cloudflare or BYOIP)*, then select your BYOIP address from the dropdown menu.

![Screenshot of a dropdown menu adding a BYOIP IPv4 address as a dedicated egress IP in a Gateway egress policy](https://developers.cloudflare.com/_astro/Gateway-byoip-dedicated-egress-ips.D0pzLAbV_2vcHQC.webp)

For more information, refer to [BYOIP for dedicated egress IPs](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/#bring-your-own-ip-address-byoip).

## 2025-08-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.6.1335.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* Improvements to better manage multi-user pre-login registrations.
* Fixed an issue preventing devices from reaching split-tunneled traffic even when WARP was disconnected.
* Fix to prevent WARP from re-enabling its firewall rules after a user-initiated disconnect.
* Improvement for faster client connectivity on high-latency captive portal networks.
* Fixed an issue where recursive CNAME records could cause intermittent WARP connectivity issues.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 version KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-08-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.6.1335.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* Fixed an issue preventing devices from reaching split-tunneled traffic even when WARP was disconnected.
* Fix to prevent WARP from re-enabling its firewall rules after a user-initiated disconnect.
* Improvement for faster client connectivity on high-latency captive portal networks.
* Fixed an issue where recursive CNAME records could cause intermittent WARP connectivity issues.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-08-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.6.1335.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* Fixed an issue preventing devices from reaching split-tunneled traffic even when WARP was disconnected.
* Fix to prevent WARP from re-enabling its firewall rules after a user-initiated disconnect.
* Improvement for faster client connectivity on high-latency captive portal networks.
* Fixed an issue where recursive CNAME records could cause intermittent WARP connectivity issues.

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-08-15

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**SFTP support for SSH with Cloudflare Access for Infrastructure**

[SSH with Cloudflare Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) now supports SFTP. It is compatible with SFTP clients, such as Cyberduck.

## 2025-08-14

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Cloudflare Access Logging supports the Customer Metadata Boundary (CMB)**

Cloudflare Access logs now support the [Customer Metadata Boundary (CMB)](https://developers.cloudflare.com/data-localization/metadata-boundary/). If you have configured the CMB for your account, all Access logging will respect that configuration.

Note

For EU CMB customers, the logs will not be stored by Access and will appear as empty in the dashboard. EU CMB customers should utilize [Logpush](https://developers.cloudflare.com/logs/logpush/) to retain their Access logging, if desired.

## 2025-08-07

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Expanded Email Link Isolation**

When you deploy MX or Inline, not only can you apply email link isolation to suspicious links in all emails (including benign), you can now also apply email link isolation to all links of a specified disposition. This provides more flexibility in controlling user actions within emails.

For example, you may want to deliver suspicious messages but isolate the links found within them so that users who choose to interact with the links will not accidentally expose your organization to threats. This means your end users are more secure than ever before.

![Expanded Email Link Isolation Configuration](https://developers.cloudflare.com/_astro/expanded-link-actions.DziIg6E8_Z1KKbw8.webp)

To isolate all links within a message based on the disposition, select **Settings** > **Link Actions** > **View** and select **Configure**. As with other other links you isolate, an interstitial will be provided to warn users that this site has been isolated and the link will be recrawled live to evaluate if there are any changes in our threat intel. Learn more about this feature on [Configure link actions](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-link-actions/).

This feature is available across these Email security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-07-30

[Magic Transit ](https://developers.cloudflare.com/magic-transit/)[Magic WAN](https://developers.cloudflare.com/magic-wan/)

**Magic Transit and Magic WAN health check data is fully compatible with the CMB EU setting.**

Today, we are excited to announce that all Magic Transit and Magic WAN customers with CMB EU ([Customer Metadata Boundary - Europe](https://developers.cloudflare.com/data-localization/metadata-boundary/)) enabled in their account will be able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API.

This ensures that all Magic Transit and Magic WAN customers with CMB EU enabled will be able to access all Magic Transit and Magic WAN features.

Specifically, these two GraphQL endpoints are now compatible with CMB EU:

* `magicTransitTunnelHealthChecksAdaptiveGroups`
* `magicTransitTunnelTrafficAdaptiveGroups`

## 2025-07-28

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Scam domain category introduced under Security Threats**

We have introduced a new Security Threat category called **Scam**. Relevant domains are marked with the Scam category. Scam typically refers to fraudulent websites and schemes designed to trick victims into giving away money or personal information.

**New category added**

| Parent ID | Parent Name | Category ID | Category Name |
| - | - | - | - |
| 21 | Security Threats | 191 | Scam |

Refer to [Gateway domain categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) to learn more.

## 2025-07-24

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.6.824.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements.

**Changes and improvements**

* Improvements to better manage multi-user pre-login registrations.
* Fixed an issue preventing devices from reaching split-tunneled traffic even when WARP was disconnected.
* Fix to prevent WARP from re-enabling its firewall rules after a user-initiated disconnect.
* Improvement to managed network detection checks for faster switching between managed networks.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 version KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-07-24

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.6.824.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements.

**Changes and improvements**

* Fixed an issue preventing devices from reaching split-tunneled traffic even when WARP was disconnected.
* Fix to prevent WARP from re-enabling its firewall rules after a user-initiated disconnect.
* Improvement to managed network detection checks for faster switching between managed networks.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-07-24

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Gateway HTTP Filtering on all ports available in open BETA**

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) can now apply [HTTP filtering](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/) to all proxied HTTP requests, not just traffic on standard HTTP (`80`) and HTTPS (`443`) ports. This means all requests can now be filtered by [A/V scanning](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/antivirus-scanning/), [file sandboxing](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/file-sandboxing/), [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/#data-in-transit), and more.

You can turn this [setting](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/#inspect-on-all-ports) on by going to **Settings** > **Network** > **Firewall** and choosing *Inspect on all ports*.

![HTTP Inspection on all ports setting](https://developers.cloudflare.com/_astro/Gateway-Inspection-all-ports.CCmwX6D0_Z1uW2Xo.webp)

To learn more, refer to [Inspect on all ports (Beta)](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/#inspect-on-all-ports).

## 2025-07-23

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.5.943.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* WARP proxy mode now uses the operating system's DNS settings. Changes made to system DNS settings while in proxy mode require the client to be turned off then back on to take effect.
* Changes to the [SCCM VPN boundary support](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#sccm-vpn-boundary-support) feature to no longer restart the SMS Agent Host (`ccmexec.exe`) service.
* Fixed an issue affecting clients in Split Tunnel Include mode, where access to split-tunneled traffic was blocked after reconnecting the client.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 version KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-07-23

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.5.943.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* WARP proxy mode now uses the operating system's DNS settings. Changes made to system DNS settings while in proxy mode require the client to be turned off then back on to take effect.
* Fixed an issue affecting clients in Split Tunnel Include mode, where access to split-tunneled traffic was blocked after reconnecting the client.
* For macOS deployments, the WARP client can now be managed using an `mdm.xml` file placed in `/Library/Application Support/Cloudflare/mdm.xml`. This new configuration option offers an alternative to the still supported method of deploying a managed plist through an MDM solution.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-07-23

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.5.943.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements**

* WARP proxy mode now uses the operating system's DNS settings. Changes made to system DNS settings while in proxy mode require the client to be turned off then back on to take effect.
* Fixed an issue affecting clients in Split Tunnel Include mode, where access to split-tunneled traffic was blocked after reconnecting the client.

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-07-22

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Google Bard Application replaced by Gemini**

The **Google Bard** application (ID: 1198) has been deprecated and fully removed from the system. It has been replaced by the **Gemini** application (ID: 1340). Any existing Gateway policies that reference the old Google Bard application will no longer function. To ensure your policies continue to work as intended, you should update them to use the new Gemini application. We recommend replacing all instances of the deprecated Bard application with the new Gemini application in your Gateway policies. For more information about application policies, please see the [Cloudflare Gateway documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/).

## 2025-07-17

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**New detection entry type: Document Matching for DLP**

You can now create [document-based](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#documents) detection entries in DLP by uploading example documents. Cloudflare will encrypt your documents and create a unique fingerprint of the file. This fingerprint is then used to identify similar documents or snippets within your organization's traffic and stored files.

![DLP](https://developers.cloudflare.com/_astro/document-match.CcN8pGgR_8o13J.webp)

**Key features and benefits:**

* **Upload documents, forms, or templates:** Easily upload .docx and .txt files (up to 10 MB) that contain sensitive information you want to protect.

* **Granular control with similarity percentage:** Define a minimum similarity percentage (0-100%) that a document must meet to trigger a detection, reducing false positives.

* **Comprehensive coverage:** Apply these document-based detection entries in:

  * **Gateway policies:** To inspect network traffic for sensitive documents as they are uploaded or shared.

  * **CASB (Cloud Access Security Broker):** To scan files stored in cloud applications for sensitive documents at rest.

* **Identify sensitive data:** This new detection entry type is ideal for identifying sensitive data within completed forms, templates, or even small snippets of a larger document, helping you prevent data exfiltration and ensure compliance.

Once uploaded and processed, you can add this new document entry into a DLP profile and policies to enhance your data protection strategy.

## 2025-07-15

[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

**Faster, more reliable UDP traffic for Cloudflare Tunnel**

Your real-time applications running over [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) are now faster and more reliable. We've completely re-architected the way `cloudflared` proxies UDP traffic in order to isolate it from other traffic, ensuring latency-sensitive applications like private DNS are no longer slowed down by heavy TCP traffic (like file transfers) on the same Tunnel.

This is a foundational improvement to Cloudflare Tunnel, delivered automatically to all customers. There are no settings to configure — your UDP traffic is already flowing faster and more reliably.

**What’s new:**

* **Faster UDP performance**: We've significantly reduced the latency for establishing new UDP sessions, making applications like private DNS much more responsive.
* **Greater reliability for mixed traffic**: UDP packets are no longer affected by heavy TCP traffic, preventing timeouts and connection drops for your real-time services.

Learn more about running [TCP or UDP applications](https://developers.cloudflare.com/reference-architecture/architectures/sase/#connecting-applications) and [private networks](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/) through [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/).

## 2025-07-10

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New onboarding guides for Zero Trust**

Use our brand new onboarding experience for Cloudflare Zero Trust. New and returning users can now engage with a **Get Started** tab with walkthroughs for setting up common use cases end-to-end.

![Zero Trust onboarding guides](https://developers.cloudflare.com/_astro/zt-onboarding-guides._18EfPbe_R7PNC.webp)

There are eight brand new onboarding guides in total:

* Securely access a private network (sets up device client and Tunnel)
* Device-to-device / mesh networking (sets up and connects multiple device clients)
* Network to network connectivity (sets up and connects multiple WARP Connectors, makes reference to Magic WAN availability for Enterprise)
* Secure web traffic (sets up device client, Gateway, pre-reqs, and initial policies)
* Secure DNS for networks (sets up a new DNS location and Gateway policies)
* Clientless web access (sets up Access to a web app, Tunnel, and public hostname)
* Clientless SSH access (all the same + the web SSH experience)
* Clientless RDP access (all the same + RDP-in-browser)

Each flow walks the user through the steps to configure the essential elements, and provides a “more details” panel with additional contextual information about what the user will accomplish at the end, along with why the steps they take are important.

Try them out now in the [Zero Trust dashboard](https://one.dash.cloudflare.com/?to=/:account/home)!

## 2025-07-07

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**Cloudy summaries for Access and Gateway Logs**

Cloudy, Cloudflare's AI Agent, will now automatically summarize your [Access](https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/) and [Gateway](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/) block logs.

In the log itself, Cloudy will summarize what occurred and why. This will be helpful for quick troubleshooting and issue correlation.

![Cloudy AI summarizes a log](https://developers.cloudflare.com/_astro/cloudy-explanation.oFZR6cXa_yzahz.webp)

If you have feedback about the Cloudy summary - good or bad - you can provide that right from the summary itself.

## 2025-07-07

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New App Library for Zero Trust Dashboard**

Cloudflare Zero Trust customers can use the App Library to get full visibility over the SaaS applications that they use in their Gateway policies, CASB integrations, and Access for SaaS applications.

**App Library**, found under **My Team**, makes information available about all Applications that can be used across the Zero Trust product suite.

![Zero Trust App Library](https://developers.cloudflare.com/_astro/app-library.D403GJ9j_1veBBu.webp)

You can use the App Library to see:

* How Applications are defined
* Where they are referenced in policies
* Whether they have Access for SaaS configured
* Review their CASB findings and integration status.

Within individual Applications, you can also track their usage across your organization, and better understand user behavior.

## 2025-07-01

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Access RDP securely from your browser — now in open beta**

[Browser-based RDP](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/) with [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) is now available in open beta for all Cloudflare customers. It enables secure, remote Windows server access without VPNs or RDP clients.

With browser-based RDP, you can:

* **Control how users authenticate to internal RDP resources** with single sign-on (SSO), multi-factor authentication (MFA), and granular access policies.
* **Record who is accessing which servers and when** to support regulatory compliance requirements and to gain greater visibility in the event of a security event.
* **Eliminate the need to install and manage software on user devices**. You will only need a web browser.
* **Reduce your attack surface** by keeping your RDP servers off the public Internet and protecting them from common threats like credential stuffing or brute-force attacks.

![Example of a browsed-based RDP Access application](https://developers.cloudflare.com/_astro/browser-based-rdp-access-app.BNXce1JL_1NEtce.webp)

To get started, see [Connect to RDP in a browser](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/).

## 2025-06-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.5.893.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains improvements and new exciting features, including [SCCM VPN boundary support](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#sccm-vpn-boundary-support) and [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate protection of post-quantum cryptography without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* Fixed a device registration issue that caused WARP connection failures when changing networks.

* Captive portal improvements and fixes:

  * Captive portal sign in notifications will now be sent through operating system notification services.
  * Fix for firewall configuration issue affecting clients in DoH only mode.

* Improved the connectivity status message in the client GUI.

* Fixed a bug affecting clients in Gateway with DoH mode where the original DNS servers were not restored after disabling WARP.

* The WARP client now applies post-quantum cryptography end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be [enabled by MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).

* Improvement to handle client configuration changes made by an MDM while WARP is not running.

* Improvements for multi-user experience to better handle fast user switching and transitions from a pre-login to a logged-in state.

* Added a WARP client device posture check for SAN attributes to the [client certificate check](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/client-certificate/).

* Fixed an issue affecting Split Tunnel Include mode, where traffic outside the tunnel was blocked when switching between Wi-Fi and Ethernet networks.

* Added [SCCM VPN boundary support](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#sccm-vpn-boundary-support) to device profile settings. With SCCM VPN boundary support enabled, operating systems will register WARP's local interface IP with the on-premise DNS server when reachable.

* Fix for an issue causing WARP connectivity to fail without full system reboot.

**Known issues**

* For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 version KB5060829](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-06-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.5.893.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains improvements and new exciting features, including [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate protection of post-quantum cryptography without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* Fixed an issue where WARP sometimes failed to automatically relaunch after updating.

* Fixed a device registration issue causing WARP connection failures when changing networks.

* Captive portal improvements and fixes:

  * Captive portal sign in notifications will now be sent through operating system notification services.
  * Fix for firewall configuration issue affecting clients in DoH only mode.

* Improved the connectivity status message in the client GUI.

* The WARP client now applies post-quantum cryptography end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be [enabled by MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).

* Improvement to handle client configuration changes made by an MDM while WARP is not running.

* Fixed an issue affecting Split Tunnel Include mode, where traffic outside the tunnel was blocked when switching between Wi-Fi and Ethernet networks.

* Improvement for WARP connectivity issues on macOS due to the operating system not accepting DNS server configurations.

* Added a WARP client device posture check for SAN attributes to the [client certificate check](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/client-certificate/).

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-06-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.5.893.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains improvements and new exciting features, including [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate protection of post-quantum cryptography without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* Fixed a device registration issue causing WARP connection failures when changing networks.

* Captive portal improvements and fixes:

  * Captive portal sign in notifications will now be sent through operating system notification services.
  * Fix for firewall configuration issue affecting clients in DoH only mode.

* Improved the connectivity status message in the client GUI.

* The WARP client now applies post-quantum cryptography end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be [enabled by MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).

* Improvement to handle client configuration changes made by MDM while WARP is not running.

* Fixed an issue affecting Split Tunnel Include mode, where traffic outside the tunnel was blocked when switching between Wi-Fi and Ethernet networks.

* Added a WARP client device posture check for SAN attributes to the [client certificate check](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/client-certificate/).

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-06-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**Cloudflare One Agent for Android (version 2.4.2)**

A new GA release for the Android Cloudflare One Agent is now available in the [Google Play Store](https://play.google.com/store/apps/details?id=com.cloudflare.cloudflareoneagent). This release contains improvements and new exciting features, including [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate [protection of post-quantum cryptography](https://blog.cloudflare.com/pq-2024/) without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* QLogs are now disabled by default and can be enabled in the app by turning on **Enable qlogs** under **Settings** > **Advanced** > **Diagnostics** > **Debug Logs**. The QLog setting from previous releases will no longer be respected.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* The WARP client now applies [post-quantum cryptography](https://blog.cloudflare.com/pq-2024/) end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be enabled by [MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).
* Fixed an issue that caused WARP connection failures on ChromeOS devices.

## 2025-06-30

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**Cloudflare One Agent for iOS (version 1.11)**

A new GA release for the iOS Cloudflare One Agent is now available in the [iOS App Store](https://apps.apple.com/us/app/cloudflare-one-agent/id6443476492). This release contains improvements and new exciting features, including [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate [protection of post-quantum cryptography](https://blog.cloudflare.com/pq-2024/) without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* QLogs are now disabled by default and can be enabled in the app by turning on **Enable qlogs** under **Settings** > **Advanced** > **Diagnostics** > **Debug Logs**. The QLog setting from previous releases will no longer be respected.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* The WARP client now applies [post-quantum cryptography](https://blog.cloudflare.com/pq-2024/) end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be enabled by [MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).

## 2025-06-23

[Data Loss Prevention ](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)[CASB ](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**Data Security Analytics in the Zero Trust dashboard**

Zero Trust now includes **Data security analytics**, providing you with unprecedented visibility into your organization sensitive data.

The new dashboard includes:

* **Sensitive Data Movement Over Time:**

  * See patterns and trends in how sensitive data moves across your environment. This helps understand where data is flowing and identify common paths.

* **Sensitive Data at Rest in SaaS & Cloud:**

  * View an inventory of sensitive data stored within your corporate SaaS applications (for example, Google Drive, Microsoft 365) and cloud accounts (such as AWS S3).

* **DLP Policy Activity:**

  * Identify which of your Data Loss Prevention (DLP) policies are being triggered most often.
  * See which specific users are responsible for triggering DLP policies.

![Data Security Analytics](https://developers.cloudflare.com/_astro/cf1-data-security-analytics-v1.BGl6fYXl_Z20un3h.webp)

To access the new dashboard, log in to [Zero Trust](https://one.dash.cloudflare.com/) and go to **Analytics** on the sidebar.

## 2025-06-18

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Gateway will now evaluate Network policies before HTTP policies from July 14th, 2025**

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) will now evaluate [Network (Layer 4) policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/) **before** [HTTP (Layer 7) policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/). This change preserves your existing security posture and does not affect which traffic is filtered — but it may impact how notifications are displayed to end users.

This change will roll out progressively between **July 14–18, 2025**. If you use HTTP policies, we recommend reviewing your configuration ahead of rollout to ensure the user experience remains consistent.

#### Updated order of enforcement

**Previous order:**

1. DNS policies
2. HTTP policies
3. Network policies

**New order:**

1. DNS policies
2. **Network policies**
3. **HTTP policies**

#### Action required: Review your Gateway HTTP policies

This change may affect block notifications. For example:

* You have an **HTTP policy** to block `example.com` and display a block page.
* You also have a **Network policy** to block `example.com` silently (no client notification).

With the new order, the Network policy will trigger first — and the user will no longer see the HTTP block page.

To ensure users still receive a block notification, you can:

* Add a client notification to your Network policy, or
* Use only the HTTP policy for that domain.

***

#### Why we’re making this change

This update is based on user feedback and aims to:

* Create a more intuitive model by evaluating network-level policies before application-level policies.
* Minimize [526 connection errors](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-526/#error-526-in-the-zero-trust-context) by verifying the network path to an origin before attempting to establish a decrypted TLS connection.

***

To learn more, visit the [Gateway order of enforcement documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/).

## 2025-06-17

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.5.828.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains new improvements in addition to the features and improvements introduced in Beta client version 2025.5.735.1.

**Changes and improvements**

* Improvement to better handle multi-user fast user switching.
* Fix for an issue causing WARP connectivity to fail without full system reboot.

**Known issues**

* Microsoft has confirmed a regression with Windows 11 starting around 24H2 that may cause performance issues for some users. These performance issues could manifest as mouse lag, audio cracking, or other slowdowns. A fix from Microsoft is expected in early July.

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected. To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-06-17

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.5.828.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains new improvements in addition to the features and improvements introduced in Beta client version 2025.5.735.1.

**Changes and improvements**

* Improvement for WARP connectivity issues on macOS due to the operating system not accepting DNS server configurations.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-06-05

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.5.735.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains improvements and new exciting features, including [SCCM VPN boundary support](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#sccm-vpn-boundary-support) and [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate protection of post-quantum cryptography without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* Fixed a device registration issue causing WARP connection failures when changing networks.
* Captive portal improvements including showing connectivity status in the client and sending system notifications for captive portal sign in.
* Fixed a bug where in Gateway with DoH mode, connection to DNS servers was not automatically restored after reconnecting WARP.
* The WARP client now applies post-quantum cryptography end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be [enabled by MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).
* Improvement to gracefully handle changes made by MDM while WARP is not running.
* Improvement for multi-user mode to avoid unnecessary key rotations when transitioning from a pre-login to a logged-in state.
* Added a WARP client device posture check for SAN attributes to the [client certificate check](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/client-certificate/).
* Fixed an issue affecting Split Tunnel Include mode, where traffic outside the tunnel was blocked when switching between Wi-Fi and Ethernet networks.
* Added [SCCM VPN boundary support](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#sccm-vpn-boundary-support) to device profile settings. With SCCM VPN boundary support enabled, operating systems will register WARP's local interface IP with the on-premise DNS server when reachable.

**Known issues**

* Microsoft has confirmed a regression with Windows 11 starting around 24H2 that may cause performance issues for some users. These performance issues could manifest as mouse lag, audio cracking, or other slowdowns. A fix from Microsoft is expected in early July.

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected. To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-06-05

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.5.735.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains improvements and new exciting features, including [post-quantum cryptography](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum). By tunneling your corporate network traffic over Cloudflare, you can now gain the immediate protection of post-quantum cryptography without needing to upgrade any of your individual corporate applications or systems.

**Changes and improvements**

* Fixed an issue where the Cloudflare WARP application may not have automatically relaunched after an update.
* Fixed a device registration issue causing WARP connection failures when changing networks.
* Captive portal improvements including showing connectivity status in the client and sending system notifications for captive portal sign in.
* The WARP client now applies post-quantum cryptography end-to-end on enabled devices accessing resources behind a Cloudflare Tunnel. This feature can be [enabled by MDM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#enable_post_quantum).
* Improvement to gracefully handle changes made by MDM while WARP is not running.
* Fixed an issue affecting Split Tunnel Include mode, where traffic outside the tunnel was blocked when switching between Wi-Fi and Ethernet networks.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-06-05

[Access ](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**Cloudflare One Analytics Dashboards and Exportable Access Report**

Cloudflare One now offers powerful new analytics dashboards to help customers easily discover available insights into their application access and network activity. These dashboards provide a centralized, intuitive view for understanding user behavior, application usage, and security posture.

!\[Cloudflare One Analytics Dashboards]\(\~/assets/images/changelog/cloudflare-one/Analytics Dashboards.png)

Additionally, a new exportable access report is available, allowing customers to quickly view high-level metrics and trends in their application access. A **preview** of the report is shown below, with more to be found in the report:

![Cloudflare One Analytics Dashboards](https://developers.cloudflare.com/_astro/access-report.C744W7JR_Td5Jj.webp)

Both features are accessible in the Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/), empowering organizations with better visibility and control.

## 2025-05-29

[Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New Gateway Analytics in the Cloudflare One Dashboard**

Users can now access significant enhancements to Cloudflare Gateway analytics, providing you with unprecedented visibility into your organization's DNS queries, HTTP requests, and Network sessions. These powerful new dashboards enable you to go beyond raw logs and gain actionable insights into how your users are interacting with the Internet and your protected resources.

You can now visualize and explore:

* Patterns Over Time: Understand trends in traffic volume and blocked requests, helping you identify anomalies and plan for future capacity.
* Top Users & Destinations: Quickly pinpoint the most active users, enabling better policy enforcement and resource allocation.
* Actions Taken: See a clear breakdown of security actions applied by Gateway policies, such as blocks and allows, offering a comprehensive view of your security posture.
* Geographic Regions: Gain insight into the global distribution of your traffic.

![Gateway Analytics](https://developers.cloudflare.com/_astro/gateway-analytics.BdSwbIBb_18Yc2n.webp)

To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and go to Analytics in the side navigation bar.

## 2025-05-27

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Gateway Protocol Detection Now Available for PAYGO and Free Plans**

All Cloudflare One Gateway users can now use Protocol detection logging and filtering, including those on Pay-as-you-go and Free plans.

With Protocol Detection, admins can identify and enforce policies on traffic proxied through Gateway based on the underlying network protocol (for example, HTTP, TLS, or SSH), enabling more granular traffic control and security visibility no matter your plan tier.

This feature is available to enable in your account network settings for all accounts. For more information on using Protocol Detection, refer to the [Protocol detection documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/).

## 2025-05-22

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.4.943.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains a hotfix for [managed networks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/managed-networks/) for the 2025.4.929.0 release.

**Changes and improvements**

* Fixed an issue where it could take up to 3 minutes for the correct device profile to be applied in some circumstances. In the worst case, it should now only take up to 40 seconds. This will be improved further in a future release.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

* Microsoft has confirmed a regression with Windows 11 starting around 24H2 that may cause performance issues for some users. These performance issues could manifest as mouse lag, audio cracking, or other slowdowns. A fix from Microsoft is expected in early July.

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

## 2025-05-22

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.4.943.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains a hotfix for [managed networks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/managed-networks/) for the 2025.4.929.0 release.

**Changes and improvements**

* Fixed an issue where it could take up to 3 minutes for the correct device profile to be applied in some circumstances. In the worst case, it should now only take up to 40 seconds. This will be improved further in a future release.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-05-22

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.4.943.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains a hotfix for [managed networks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/managed-networks/) for the 2025.4.929.0 release.

**Changes and improvements**

* Fixed an issue where it could take up to 3 minutes for the correct device profile to be applied in some circumstances. In the worst case, it should now only take up to 40 seconds. This will be improved further in a future release.

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-05-18

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New Applications Added to Zero Trust**

42 new applications have been added for Zero Trust support within the Application Library and Gateway policy enforcement, giving you the ability to investigate or apply inline policies to these applications.

33 of the 42 applications are Artificial Intelligence applications. The others are Human Resources (2 applications), Development (2 applications), Productivity (2 applications), Sales & Marketing, Public Cloud, and Security.

To view all available applications, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/), navigate to the **App Library** under **My Team**.

For more information on creating Gateway policies, see our [Gateway policy documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/).

## 2025-05-16

[Access ](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**New Access Analytics in the Cloudflare One Dashboard**

A new Access Analytics dashboard is now available to all Cloudflare One customers. Customers can apply and combine multiple filters to dive into specific slices of their Access metrics. These filters include:

* Logins granted and denied
* Access events by type (SSO, Login, Logout)
* Application name (Salesforce, Jira, Slack, etc.)
* Identity provider (Okta, Google, Microsoft, onetimepin, etc.)
* Users (`chris@cloudflare.com`, `sally@cloudflare.com`, `rachel@cloudflare.com`, etc.)
* Countries (US, CA, UK, FR, BR, CN, etc.)
* Source IP address
* App type (self-hosted, Infrastructure, RDP, etc.)

![Access Analytics](https://developers.cloudflare.com/_astro/accessanalytics.DYXgwZCl_cA6SI.webp)

To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and find Analytics in the side navigation bar.

## 2025-05-15

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Open email attachments with Browser Isolation**

You can now safely open email attachments to view and investigate them.

What this means is that messages now have a **Attachments** section. Here, you can view processed attachments and their classifications (for example, *Malicious*, *Suspicious*, *Encrypted*). Next to each attachment, a **Browser Isolation** icon allows your team to safely open the file in a **clientless, isolated browser** with no risk to the analyst or your environment.

![Attachment-RBI](https://developers.cloudflare.com/_astro/Attachment-RBI.U9Dp8dJO_ySprI.webp)

To use this feature, you must:

* Enable **Clientless Web Isolation** in your Zero Trust settings.
* Have **Browser Isolation (BISO)** seats assigned.

For more details, refer to our [setup guide](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/).

Some attachment types may not render in Browser Isolation. If there is a file type that you would like to be opened with Browser Isolation, reach out to your Cloudflare contact.

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-05-14

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.4.929.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains two significant changes all customers should be aware of:

1. All DNS traffic now flows inside the WARP tunnel. Customers are no longer required to configure their local firewall rules to allow our [DoH IP addresses and domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#doh-ip).
2. When using MASQUE, the connection will fall back to HTTP/2 (TCP) when we detect that HTTP/3 traffic is blocked. This allows for a much more reliable connection on some public WiFi networks.

**Changes and improvements**

* Fixed an issue causing reconnection loops when captive portals are detected.
* Fixed an issue that caused WARP client disk encryption posture checks to fail due to missing drive names.
* Fixed an issue where managed network policies could incorrectly report network location beacons as missing.
* Improved DEX test error reporting.
* Fixed an issue where some parts of the WARP Client UI were missing in high contrast mode.
* Fixed an issue causing client notifications to fail in IPv6 only environments which prevented the client from receiving configuration changes to settings like device profile.
* Added a TCP fallback for the MASQUE tunnel protocol to improve connectivity on networks that block UDP or HTTP/3 specifically.
* Added new IP addresses for [tunnel connectivity checks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#connectivity-checks). If your organization uses a firewall or other policies you will need to exempt these IPs.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* Improved the error message displayed in the client GUI when the rate limit for entering an incorrect admin override code is met.
* Improved handling of non-SLAAC IPv6 interface addresses for better connectivity in IPv6 only environments.
* Fixed an issue where frequent network changes could cause WARP to become unresponsive.
* Improvement for WARP to check if tunnel connectivity fails or times out at device wake before attempting to reconnect.
* Fixed an issue causing WARP connection disruptions after network changes.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

* Microsoft has confirmed a regression with Windows 11 starting around 24H2 that may cause performance issues for some users. These performance issues could manifest as mouse lag, audio cracking, or other slowdowns. A fix from Microsoft is expected in early July.

* Devices with `KB5055523` installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

## 2025-05-14

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Domain Categories improvements**

**New categories added**

| Parent ID | Parent Name | Category ID | Category Name |
| - | - | - | - |
| 1 | Ads | 66 | Advertisements |
| 3 | Business & Economy | 185 | Personal Finance |
| 3 | Business & Economy | 186 | Brokerage & Investing |
| 21 | Security Threats | 187 | Compromised Domain |
| 21 | Security Threats | 188 | Potentially Unwanted Software |
| 6 | Education | 189 | Reference |
| 9 | Government & Politics | 190 | Charity and Non-profit |

**Changes to existing categories**

| Original Name | New Name |
| - | - |
| Religion | Religion & Spirituality |
| Government | Government/Legal |
| Redirect | URL Alias/Redirect |

Refer to [Gateway domain categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) to learn more.

## 2025-05-13

[Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

**SAML HTTP-POST bindings support for RBI**

Remote Browser Isolation (RBI) now supports SAML HTTP-POST bindings, enabling seamless authentication for SSO-enabled applications that rely on POST-based SAML responses from Identity Providers (IdPs) within a Remote Browser Isolation session. This update resolves a previous limitation that caused `405` errors during login and improves compatibility with multi-factor authentication (MFA) flows.

With expanded support for major IdPs like Okta and Azure AD, this enhancement delivers a more consistent and user-friendly experience across authentication workflows. Learn how to [set up Remote Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/).

## 2025-05-13

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**New Applications Added for DNS Filtering**

You can now create DNS policies to manage outbound traffic for an expanded list of applications. This update adds support for 273 new applications, giving you more control over your organization's outbound traffic.

With this update, you can:

* Create DNS policies for a wider range of applications
* Manage outbound traffic more effectively
* Improve your organization's security and compliance posture

For more information on creating DNS policies, see our [DNS policy documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/).

## 2025-05-12

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.4.929.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains two significant changes all customers should be aware of:

1. All DNS traffic now flows inside the WARP tunnel. Customers are no longer required to configure their local firewall rules to allow our [DoH IP addresses and domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#doh-ip).
2. When using MASQUE, the connection will fall back to HTTP/2 (TCP) when we detect that HTTP/3 traffic is blocked. This allows for a much more reliable connection on some public WiFi networks.

**Changes and improvements**

* Fixed an issue where the managed network policies could incorrectly report network location beacons as missing.
* Improved DEX test error reporting.
* Fixed an issue causing client notifications to fail in IPv6 only environments which prevented the client from receiving configuration changes to settings like device profile.
* Added a TCP fallback for the MASQUE tunnel protocol to improve connectivity on networks that block UDP or HTTP/3 specifically.
* Added new IP addresses for [tunnel connectivity checks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#connectivity-checks). If your organization uses a firewall or other policies you will need to exempt these IPs.
* Fixed an issue where frequent network changes could cause WARP to become unresponsive.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* Improvement for WARP to check if tunnel connectivity fails or times out at device wake before attempting to reconnect.
* Fixed an issue causing WARP connection disruptions after network changes.

**Known issues**

* Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

## 2025-05-12

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.4.929.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains two significant changes all customers should be aware of:

1. All DNS traffic now flows inside the WARP tunnel. Customers are no longer required to configure their local firewall rules to allow our [DoH IP addresses and domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#doh-ip).
2. When using MASQUE, the connection will fall back to HTTP/2 (TCP) when we detect that HTTP/3 traffic is blocked. This allows for a much more reliable connection on some public WiFi networks.

**Changes and improvements**

* Fixed an issue where the managed network policies could incorrectly report network location beacons as missing.
* Improved DEX test error reporting.
* Fixed an issue causing client notifications to fail in IPv6 only environments which prevented the client from receiving configuration changes to settings like device profile.
* Improved captive portal detection.
* Added a TCP fallback for the MASQUE tunnel protocol to improve connectivity on networks that block UDP or HTTP/3 specifically.
* Added new IP addresses for [tunnel connectivity checks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#connectivity-checks). If your organization uses a firewall or other policies you will need to exempt these IPs.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* Improved the error message displayed in the client GUI when the rate limit for entering an incorrect admin override code is met.
* Improved handling of non-SLAAC IPv6 interface addresses for better connectivity in IPv6 only environments.
* Fixed an issue where frequent network changes could cause WARP to become unresponsive.
* Improvement for WARP to check if tunnel connectivity fails or times out at device wake before attempting to reconnect.
* Fixed an issue causing WARP connection disruptions after network changes.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-05-12

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**Case Sensitive Custom Word Lists**

You can now configure [custom word lists](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#custom-wordlist) to enforce case sensitivity. This setting supports flexibility where needed and aims to reduce false positives where letter casing is critical.

![dlp](https://developers.cloudflare.com/_astro/case-sesitive-cwl.MPuOc_3r_2hrao0.webp)

## 2025-05-08

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Open email links with Browser Isolation**

You can now safely open links in emails to view and investigate them.

![Open links with Browser Isolation](https://developers.cloudflare.com/_astro/investigate-links.pYbpGkt5_E8W6p.webp)

From **Investigation**, go to **View details**, and look for the **Links identified** section. Next to each link, the Cloudflare dashboard will display an **Open in Browser Isolation** icon which allows your team to safely open the link in a clientless, isolated browser with no risk to the analyst or your environment. Refer to [Open links](https://developers.cloudflare.com/cloudflare-one/email-security/investigation/search-email/#open-links) to learn more about this feature.

To use this feature, you must:

* Enable **Clientless Web Isolation** in your Zero Trust settings.
* Have **Browser Isolation (RBI)** seats assigned.

For more details, refer to our [setup guide](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/).

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-05-07

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**Send forensic copies to storage without DLP profiles**

You can now [send DLP forensic copies](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#send-http-requests-to-logpush-destination/) to third-party storage for any HTTP policy with an `Allow` or `Block` action, without needing to include a DLP profile. This change increases flexibility for data handling and forensic investigation use cases.

By default, Gateway will send all matched HTTP requests to your configured DLP Forensic Copy jobs.

![DLP](https://developers.cloudflare.com/_astro/forensic-copies-for-all.fxeFrCY4_1rLkLy.webp)

## 2025-05-01

[Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

**Browser Isolation Overview page for Zero Trust**

A new **Browser Isolation Overview** page is now available in the Cloudflare Zero Trust dashboard. This centralized view simplifies the management of [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) deployments, providing:

* **Streamlined Onboarding:** Easily set up and manage isolation policies from one location.
* **Quick Testing:** Validate [clientless web application isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/) with ease.
* **Simplified Configuration:** Configure [isolated access applications](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/isolate-application/) and policies efficiently.
* **Centralized Monitoring:** Track aggregate usage and blocked actions.

This update consolidates previously disparate settings, accelerating deployment, improving visibility into isolation activity, and making it easier to ensure your protections are working effectively.

![Browser Isolation Overview](https://developers.cloudflare.com/_astro/browser-isolation-overview.Ljd5ax_O_PTyT8.webp)

To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and find Browser Isolation in the side navigation bar.

## 2025-04-30

[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

**Dark Mode for Zero Trust Dashboard**

The [Cloudflare Zero Trust dashboard](https://one.dash.cloudflare.com/) now supports Cloudflare's native dark mode for all accounts and plan types.

Zero Trust Dashboard will automatically accept your user-level preferences for system settings, so if your Dashboard appearance is set to 'system' or 'dark', the Zero Trust dashboard will enter dark mode whenever the rest of your Cloudflare account does.

![Zero Trust dashboard supports dark mode](https://developers.cloudflare.com/_astro/dark-mode.DfLeS20d_2mgqkI.webp)

* Zero Trust Dashboard

  To update your view preference in the Zero Trust dashboard:

  1. Log into the [Zero Trust dashboard](https://one.dash.cloudflare.com/).
  2. Select your user icon.
  3. Select **Dark Mode**.

* Core Dashboard

  To update your view preference in the Core dashboard:

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com).
  2. Go to **My Profile**
  3. For **Appearance**, choose **Dark**.

## 2025-04-28

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**FQDN Filtering For Gateway Egress Policies**

Cloudflare One administrators can now control which egress IP is used based on a destination's fully qualified domain name (FDQN) within Gateway Egress policies.

* Host, Domain, Content Categories, and Application selectors are now available in the Gateway Egress policy builder in beta.
* During the beta period, you can use these selectors with traffic on-ramped to Gateway with the WARP client, proxy endpoints (commonly deployed with PAC files), or Cloudflare Browser Isolation.
  * For WARP client support, additional configuration is required. For more information, refer to the [WARP client configuration documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#limitations).

![Egress by FQDN and Hostname](https://developers.cloudflare.com/_astro/Gateway-Egress-FQDN-Policy-preview.Civon5p8_Z1NyGJz.webp)

This will help apply egress IPs to your users' traffic when an upstream application or network requires it, while the rest of their traffic can take the most performant egress path.

## 2025-04-22

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.4.589.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

**Changes and improvements**

* Fixed an issue causing reconnection loops when captive portals are detected.
* Fixed an issue that caused WARP client disk encryption posture checks to fail due to missing drive names.
* Fixed an issue where managed network policies could incorrectly report network location beacons as missing.
* Improved error reporting for DEX tests.
* Improved WARP client UI high contrast mode.
* Fixed an issue causing client notifications to fail in IPv6 only environments which prevented the client from receiving configuration changes to settings like device profile.
* Added a TCP fallback for the MASQUE tunnel protocol to improve compatibility with networks on MASQUE.
* Added new IP addresses for [tunnel connectivity checks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#connectivity-checks). If your organization uses a firewall or other policies you will need to exempt these IPs.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* Improved the error message displayed in the client GUI when the rate limit for entering an incorrect admin override code is met.
* Added a [Collect Captive Portal Diag](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/#get-captive-portal-logs) button in the client GUI to make it easier for users to collect captive portal debugging diagnostics.
* Improved handling of non-SLAAC IPv6 interface addresses for better connectivity in IPv6 only environments.
* Fixed an issue where frequent network changes could cause WARP to become unresponsive.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-04-22

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.4.589.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

**Changes and improvements**

* Fixed an issue where managed network policies could incorrectly report network location beacons as missing.
* Improved DEX test error reporting.
* Fixed an issue causing client notifications to fail in IPv6 only environments which prevented the client from receiving configuration changes to settings like device profile.
* Improved captive portal detection.
* Added a TCP fallback for the MASQUE tunnel protocol to improve compatibility with networks on MASQUE.
* Added new IP addresses for [tunnel connectivity checks](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#connectivity-checks). If your organization uses a firewall or other policies you will need to exempt these IPs.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* Improved the error message displayed in the client GUI when the rate limit for entering an incorrect admin override code is met.
* Added a [Collect Captive Portal Diag](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/#get-captive-portal-logs) button in the client GUI to make it easier for users to collect captive portal debugging diagnostics.
* Improved handling of non-SLAAC IPv6 interface addresses for better connectivity in IPv6 only environments.
* Fixed an issue where frequent network changes could cause WARP to become unresponsive.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-04-21

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Access bulk policy tester**

The [Access bulk policy tester](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/policy-management/#test-all-policies-in-an-application) is now available in the Cloudflare Zero Trust dashboard. The bulk policy tester allows you to simulate Access policies against your entire user base before and after deploying any changes. The policy tester will simulate the configured policy against each user's last seen identity and device posture (if applicable).

![Example policy tester](https://developers.cloudflare.com/_astro/example-policy-tester.DCY8hQvx_ZVibzJ.webp)

## 2025-04-14

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**New predefined detection entry for ICD-11**

You now have access to the World Health Organization (WHO) 2025 edition of the [International Classification of Diseases 11th Revision (ICD-11)](https://www.who.int/news/item/14-02-2025-who-releases-2025-update-to-the-international-classification-of-diseases-%28icd-11%29) as a predefined detection entry. The new dataset can be found in the [Health Information](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/predefined-profiles/#health-information) predefined profile.

ICD-10 dataset remains available for use.

## 2025-04-11

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**HTTP redirect and custom block page redirect**

You can now use more flexible redirect capabilities in Cloudflare One with Gateway.

* A new **Redirect** action is available in the HTTP policy builder, allowing admins to redirect users to any URL when their request matches a policy. You can choose to preserve the original URL and query string, and optionally include policy context via query parameters.
* For **Block** actions, admins can now configure a custom URL to display when access is denied. This block page redirect is set at the account level and can be overridden in DNS or HTTP policies. Policy context can also be passed along in the URL.

Learn more in our documentation for [HTTP Redirect](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#redirect) and [Block page redirect](https://developers.cloudflare.com/cloudflare-one/reusable-components/custom-pages/gateway-block-page/#redirect-to-a-block-page).

## 2025-04-09

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Cloudflare Zero Trust SCIM User and Group Provisioning Logs**

[Cloudflare Zero Trust SCIM provisioning](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim) now has a full audit log of all create, update and delete event from any SCIM Enabled IdP. The [SCIM logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/) support filtering by IdP, Event type, Result and many more fields. This will help with debugging user and group update issues and questions.

SCIM logs can be found on the Zero Trust Dashboard under **Logs** -> **SCIM provisioning**.

![Example SCIM Logs](https://developers.cloudflare.com/_astro/example-scim-log.Bv5Zqckh_Z1GHFvk.webp)

## 2025-04-08

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.2.664.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains a hotfix for captive portal detection for the 2025.2.600.0 release.

**Changes and improvements**

* Fix to reduce the number of browser tabs opened during captive portal logins.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-04-08

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.2.664.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains a hotfix for captive portal detection and PF state tables for the 2025.2.600.0 release.

**Changes and improvements**

* Fix to reduce the number of browser tabs opened during captive portal logins.
* Improvement to exclude local DNS traffic entries from PF state table to reduce risk of connectivity issues from exceeding table capacity.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.

## 2025-04-01

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**CASB and Email security**

With Email security, you get two free CASB integrations.

Use one SaaS integration for Email security to sync with your directory of users, take actions on delivered emails, automatically provide EMLs for reclassification requests for clean emails, discover CASB findings and more.

With the other integration, you can have a separate SaaS integration for CASB findings for another SaaS provider.

Refer to [Add an integration](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/#add-an-integration) to learn more about this feature.

![CASB-EmailSecurity](https://developers.cloudflare.com/_astro/CASB-EmailSecurity.B1wd9be2_Z1qI0fQ.webp)

This feature is available across these Email security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-03-31

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.2.600.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains support for a new WARP setting, [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override). It also includes significant improvements to our captive portal / public Wi-Fi detection logic. If you have experienced captive portal issues in the past, re-test and give this version a try.

**Changes and improvements**

* Improved [captive portal detection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/) to make more public networks compatible and have faster detection.
* Improved error messages shown in the app.
* WARP tunnel protocol details can now be viewed using the `warp-cli tunnel stats` command.
* Fixed an issue with device revocation and re-registration when switching configurations.
* Added a new [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) setting. This setting puts account administrators in control of disabling and enabling WARP across all devices registered to an account from the dashboard. Global WARP override is disabled by default.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.3 or later.

## 2025-03-31

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.2.600.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains support for a new WARP setting, [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override). It also includes significant improvements to our captive portal / public Wi-Fi detection logic. If you have experienced captive portal issues in the past, re-test and give this version a try.

**Changes and improvements**

* Improved [captive portal detection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/) to make more public networks compatible and have faster detection.
* Improved error messages shown in the app.
* Added the ability to control if the WARP interface IPs are [registered with DNS servers](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#warp-interface-ip-dns-registration) or not.
* Removed DNS logs view from the Windows client GUI. DNS logs can be viewed as part of `warp-diag` or by viewing the log file on the user's local directory.
* Fixed an issue that would result in a user receiving multiple re-authentication requests when waking their device from sleep.
* WARP tunnel protocol details can now be viewed using the `warp-cli tunnel stats` command.
* Improvements to [Windows multi-user](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/windows-multiuser/) including support for fast user switching. If you are interested in testing this feature, reach out to your Cloudflare account team.
* Fixed an issue with device revocation and re-registration when switching configurations.
* Fixed an issue where DEX tests would run during certain sleep states where the networking stack was not fully up. This would result in failures that would be ignored.
* Added a new [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) setting. This setting puts account administrators in control of disabling and enabling WARP across all devices registered to an account from the dashboard. Global WARP override is disabled by default.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-03-31

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.2.600.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains support for a new WARP setting, [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override). It also includes significant improvements to our captive portal / public Wi-Fi detection logic. If you have experienced captive portal issues in the past, re-test and give this version a try.

**Changes and improvements**

* Improved [captive portal detection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/) to make more public networks compatible and have faster detection.
* WARP tunnel protocol details can now be viewed using the `warp-cli tunnel stats` command.
* Fixed an issue with device revocation and re-registration when switching configurations.
* Added a new [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) setting. This setting puts account administrators in control of disabling and enabling WARP across all devices registered to an account from the dashboard. Global WARP override is disabled by default.

## 2025-03-21

[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Secure DNS Locations Management User Role**

We're excited to introduce the [**Cloudflare Zero Trust Secure DNS Locations Write role**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/#secure-dns-locations), designed to provide DNS filtering customers with granular control over third-party access when configuring their Protective DNS (PDNS) solutions.

Many DNS filtering customers rely on external service partners to manage their DNS location endpoints. This role allows you to grant access to external parties to administer DNS locations without overprovisioning their permissions.

**Secure DNS Location Requirements:**

* Mandate usage of [Bring your own DNS resolver IP addresses](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/dns-resolver-ips/#bring-your-own-dns-resolver-ip) if available on the account.

* Require source network filtering for IPv4/IPv6/DoT endpoints; token authentication or source network filtering for the DoH endpoint.

You can assign the new role via Cloudflare Dashboard (`Manage Accounts > Members`) or via API. For more information, refer to the [Secure DNS Locations documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/#secure-dns-locations).

## 2025-03-17

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**Cloudflare One Agent for Android (version 2.4)**

A new GA release for the Android Cloudflare One Agent is now available in the [Google Play Store](https://play.google.com/store/apps/details?id=com.cloudflare.cloudflareoneagent). This release includes a new feature allowing [team name insertion by URL](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/#enroll-using-a-url) during enrollment, as well as fixes and minor improvements.

**Changes and improvements**

* Improved in-app error messages.
* Improved mobile client login with support for [team name insertion by URL](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/#enroll-using-a-url).
* Fixed an issue preventing admin split tunnel settings taking priority for traffic from certain applications.

## 2025-03-17

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**Cloudflare One Agent for iOS (version 1.10)**

A new GA release for the iOS Cloudflare One Agent is now available in the [iOS App Store](https://apps.apple.com/us/app/cloudflare-one-agent/id6443476492). This release includes a new feature allowing [team name insertion by URL](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/#enroll-using-a-url) during enrollment, as well as fixes and minor improvements.

**Changes and improvements**

* Improved in-app error messages.
* Improved mobile client login with support for [team name insertion by URL](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/#enroll-using-a-url).
* Bug fixes and performance improvements.

## 2025-03-13

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.2.460.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains significant improvements to our captive portal / public Wi-Fi detection logic. If you have experienced captive portal issues in the past, re-test and give this version a try.

**Changes and improvements**

* Improved [captive portal detection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/) to make more public networks compatible and have faster detection.
* Improved error messages shown in the app.
* WARP tunnel protocol details can now be viewed using the `warp-cli tunnel stats` command.
* Fixed issue with device revocation and re-registration when switching configurations.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.3 or later.

## 2025-03-13

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.2.460.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains significant improvements to our captive portal / public Wi-Fi detection logic. If you have experienced captive portal issues in the past, re-test and give this version a try.

**Changes and improvements**

* Improved [captive portal detection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/) to make more public networks compatible and have faster detection.
* Improved error messages shown in the app.
* Added the ability to control if the WARP interface IPs are [registered with DNS servers](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#warp-interface-ip-dns-registration) or not.
* Removed DNS logs view from the Windows client GUI. DNS logs can be viewed as part of `warp-diag` or by viewing the log file on the user's local directory.
* Fixed issue that would result in a user receiving multiple re-authentication requests when waking their device from sleep.
* WARP tunnel protocol details can now be viewed using the `warp-cli tunnel stats` command.
* Improvements to [Windows multi-user](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/windows-multiuser/) including support for fast user switching. If you are interested in testing this feature, reach out to your Cloudflare account team.
* Fixed issue with device revocation and re-registration when switching configurations.
* Fixed issue where DEX tests would run during certain sleep states where the networking stack was not fully up. This would result in failures that would be ignored.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-03-07

[Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/)

**Cloudflare One Agent now supports Endpoint Monitoring**

[Digital Experience Monitoring (DEX)](https://developers.cloudflare.com/cloudflare-one/insights/dex/) provides visibility into device, network, and application performance across your Cloudflare SASE deployment. The latest release of the Cloudflare One agent (v2025.1.861) now includes device endpoint monitoring capabilities to provide deeper visibility into end-user device performance which can be analyzed directly from the dashboard.

Device health metrics are now automatically collected, allowing administrators to:

* View the last network a user was connected to
* Monitor CPU and RAM utilization on devices
* Identify resource-intensive processes running on endpoints

![Device endpoint monitoring dashboard](https://developers.cloudflare.com/_astro/cloudflare-one-agent-health-monitoring.XXtiRuOp_Z144rRU.webp)

This feature complements existing DEX features like [synthetic application monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/) and [network path visualization](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/traceroute/), creating a comprehensive troubleshooting workflow that connects application performance with device state.

For more details refer to our [DEX](https://developers.cloudflare.com/cloudflare-one/insights/dex/) documentation.

## 2025-03-04

[Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

**Gain visibility into user actions in Zero Trust Browser Isolation sessions**

We're excited to announce that new logging capabilities for [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) through [Logpush](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/) are available in Beta starting today!

With these enhanced logs, administrators can gain visibility into end user behavior in the remote browser and track blocked data extraction attempts, along with the websites that triggered them, in an isolated session.

```json
{
  "AccountID": "$ACCOUNT_ID",
  "Decision": "block",
  "DomainName": "www.example.com",
  "Timestamp": "2025-02-27T23:15:06Z",
  "Type": "copy",
  "UserID": "$USER_ID"
}
```

User Actions available:

* **Copy & Paste**
* **Downloads & Uploads**
* **Printing**

Learn more about how to get started with Logpush in our [documentation](https://developers.cloudflare.com/logs/logpush/).

## 2025-03-03

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**New SAML and OIDC Fields and SAML transforms for Access for SaaS**

[Access for SaaS applications](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/) now include more configuration options to support a wider array of SaaS applications.

**SAML and OIDC Field Additions**

OIDC apps now include:

* Group Filtering via RegEx
* OIDC Claim mapping from an IdP
* OIDC token lifetime control
* Advanced OIDC auth flows including hybrid and implicit flows

![OIDC field additions](https://developers.cloudflare.com/_astro/oidc-claims.2di8l9Lv_ZOEc1S.webp)

SAML apps now include improved SAML attribute mapping from an IdP.

![SAML field additions](https://developers.cloudflare.com/_astro/saml-attribute-statements.CW45j5Qi_ZjcQ8E.webp)

**SAML transformations**

SAML identities sent to Access applications can be fully customized using JSONata expressions. This allows admins to configure the precise identity SAML statement sent to a SaaS application.

![Configured SAML statement sent to application](https://developers.cloudflare.com/_astro/transformation-box.DyKn-DdN_7LzOj.webp)

## 2025-03-01

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Use Logpush for Email security detections**

You can now send detection logs to an endpoint of your choice with Cloudflare Logpush.

Filter logs matching specific criteria you have set and select from over 25 fields you want to send. When creating a new Logpush job, remember to select **Email security alerts** as the dataset.

![logpush-detections](https://developers.cloudflare.com/_astro/Logpush-Detections.Dc5tHta3_Zr7mfa.webp)

For more information, refer to [Enable detection logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/enable-logs/#enable-detection-logs).

This feature is available across these Email security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-27

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Check status of Email security or Area 1**

Concerns about performance for Email security or Area 1? You can now check the operational status of both on the [Cloudflare Status page](https://www.cloudflarestatus.com/).

For Email security, look under **Cloudflare Sites and Services**.

* **Dashboard** is the dashboard for Cloudflare, including Email security
* **Email security (Zero Trust)** is the processing of email
* **API** are the Cloudflare endpoints, including the ones for Email security

For Area 1, under **Cloudflare Sites and Services**:

* **Area 1 - Dash** is the dashboard for Cloudflare, including Email security
* **Email security (Area1)** is the processing of email
* **Area 1 - API** are the Area 1 endpoints

![Status-page](https://developers.cloudflare.com/_astro/Status-Page.DcFJ1286_2uqBex.webp)

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-25

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Use DLP Assist for M365**

Cloudflare Email security customers who have Microsoft 365 environments can quickly deploy an Email DLP (Data Loss Prevention) solution for free.

Simply deploy our add-in, create a DLP policy in Cloudflare, and configure Outlook to trigger behaviors like displaying a banner, alerting end users before sending, or preventing delivery entirely.

Refer to [Outbound Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/email-security/outbound-dlp/) to learn more about this feature.

In GUI alert:

![DLP-Alert](https://developers.cloudflare.com/_astro/DLP-Alert.5s-fbKn3_1ALITN.webp)

Alert before sending:

![DLP-Pop-up](https://developers.cloudflare.com/_astro/DLP-Pop-up.0gkYy7o5_1vABF7.webp)

Prevent delivery:

![DLP-Blocked](https://developers.cloudflare.com/_astro/DLP-Blocked.CmQkGrnM_ZBxTWo.webp)

This feature is available across these Email security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.1.861.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains only improvements.

**Changes and improvements**

* Improved command line interface for Access for Infrastructure with added function for filtering and ordering.
* Fixed client connectivity issues when switching between managed network profiles that use different WARP protocols.
* Added support for WARP desktop to use additional DoH endpoints to help reduce NAT congestion.
* Improved connectivity check reliability in certain split tunnel configurations.
* Improved reading of device DNS settings at connection restart.
* Improved WARP connectivity in environments with virtual machine interfaces.
* Improved Wireguard connection stability on reconnections.
* Improved reliability of device posture checks for OS Version, Unique Client ID, Domain Joined, Disk Encryption, and Firewall attributes.
* Added additional HTTP/3 QUIC connectivity test to warp-diag.
* Added support for collection of system health metrics for enhanced device Digital Experience Monitoring.
* Automated the removal of active registrations for devices with multiple registrations with the same Zero Trust organization.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-02-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.1.861.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

Note: If using macOS Sequoia, Cloudflare recommends the use of macOS 15.3 or later. With macOS 15.3, Apple addressed several issues that may have caused the WARP client to not behave as expected when used with macOS 15.0.x.

**Changes and improvements**

* Improved command line interface for Access for Infrastructure with added function for filtering and ordering.
* Fixed client connectivity issues when switching between managed network profiles that use different WARP protocols.
* Improved OS version posture checks on macOS for greater reliability and availability.
* Added support for WARP desktop to use additional DoH endpoints to help reduce NAT congestion.
* Improved Wireguard connection stability on reconnections.
* Added additional HTTP/3 QUIC connectivity test to `warp-diag`.
* Added support for collection of system health metrics for enhanced device Digital Experience Monitoring.
* Automated the removal of active registrations for devices with multiple registrations with the same Zero Trust organization.
* Fixes issues with deleted registration at start up.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.3 or later.

## 2025-02-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2025.1.861.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release includes fixes and minor improvements.

**Changes and improvements**

* Improved command line interface for Access for Infrastructure with added function for filtering and ordering.
* Fixed client connectivity issues when switching between managed network profiles that use different WARP protocols.
* Added support for WARP desktop to use additional DoH endpoints to help reduce NAT congestion.
* Improved Wireguard connection stability on reconnections.
* Added additional HTTP/3 QUIC connectivity test to `warp-diag`.
* Added support for collection of system health metrics for enhanced device Digital Experience Monitoring.
* Automated the removal of active registrations for devices with multiple registrations with the same Zero Trust organization.

## 2025-02-14

[Magic WAN](https://developers.cloudflare.com/magic-wan/)

**Configure your Magic WAN Connector to connect via static IP assigment**

You can now locally configure your [Magic WAN Connector](https://developers.cloudflare.com/magic-wan/configuration/connector/) to work in a static IP configuration.

This local method does not require having access to a DHCP Internet connection. However, it does require being comfortable with using tools to access the serial port on Magic WAN Connector as well as using a serial terminal client to access the Connector's environment.

For more details, refer to [WAN with a static IP address](https://developers.cloudflare.com/magic-wan/configuration/connector/configure-hardware-connector/#bootstrap-via-serial-console).

## 2025-02-07

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Open email links with Security Center**

You can now investigate links in emails with Cloudflare Security Center to generate a report containing a myriad of technical details: a phishing scan, SSL certificate data, HTTP request and response data, page performance data, DNS records, what technologies and libraries the page uses, and more.

![Open links in Security Center](https://developers.cloudflare.com/_astro/Open-Links-Security-Center.b-LJU4YB_xe9E.webp)

From **Investigation**, go to **View details**, and look for the **Links identified** section. Select **Open in Security Center** next to each link. **Open in Security Center** allows your team to quickly generate a detailed report about the link with no risk to the analyst or your environment.

For more details, refer to [Open links](https://developers.cloudflare.com/cloudflare-one/email-security/investigation/search-email/#open-links).

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-07

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.1.634.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains only a hotfix from the 2025.1.447.1 release. Note: If using macOS Sequoia, Cloudflare recommends the use of macOS 15.2 or later. With macOS 15.2, Apple addressed several issues that may have caused the WARP client to not behave as expected when used with macOS 15.0.x. **Changes and improvements** - Improved device registration retrieval for graceful restarts **Known issues** - macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.2 or later.

## 2025-02-03

[Data Loss Prevention ](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

**Block files that are password-protected, compressed, or otherwise unscannable.**

Gateway HTTP policies can now block files that are password-protected, compressed, or otherwise unscannable.

These unscannable files are now matched with the [Download and Upload File Types traffic selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#download-and-upload-file-types) for HTTP policies:

* Password-protected Microsoft Office document
* Password-protected PDF
* Password-protected ZIP archive
* Unscannable ZIP archive

To get started inspecting and modifying behavior based on these and other rules, refer to [HTTP filtering](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/).

## 2025-01-28

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2025.1.447.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains only improvements.

Note: If using macOS Sequoia, Cloudflare recommends the use of macOS 15.2 or later. With macOS 15.2, Apple addressed several issues that may have caused the WARP client to not behave as expected when used with macOS 15.0.x.

**Changes and improvements**

* Improved command line interface for Access for Infrastructure with added function for filtering and ordering.
* Fixed client connectivity issues when switching between managed network profiles that use different WARP protocols.
* Improved OS version posture checks on macOS for greater reliability and availability.
* Added support for WARP desktop to use additional DoH endpoints to help reduce NAT congestion.
* Improved Wireguard connection stability on reconnections.
* Added additional HTTP/3 QUIC connectivity test to `warp-diag`.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.2 or later.

## 2025-01-28

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2025.1.447.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains only improvements.

**Changes and improvements**

* Improved command line interface for Access for Infrastructure with added function for filtering and ordering.
* Fixed client connectivity issues when switching between managed network profiles that use different WARP protocols.
* Added support for WARP desktop to use additional DoH endpoints to help reduce NAT congestion.
* Improved Windows multi-user feature with minor bug fixes and optimizations.
* Improved connectivity check reliability in certain split tunnel configurations.
* Improved reading of device DNS settings at connection restart.
* Improved WARP connectivity in environments with virtual machine interfaces.
* Improved Wireguard connection stability on reconnections.
* Improved reliability of device posture checks for OS Version, Unique Client ID, Domain Joined, Disk Encryption, and Firewall attributes.
* Added additional HTTP/3 QUIC connectivity test to `warp-diag`.

**Known issues**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2025-01-20

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

**Detect source code leaks with Data Loss Prevention**

You can now detect source code leaks with Data Loss Prevention (DLP) with predefined checks against common programming languages.

The following programming languages are validated with natural language processing (NLP).

* C
* C++
* C#
* Go
* Haskell
* Java
* JavaScript
* Lua
* Python
* R
* Rust
* Swift

DLP also supports confidence level for [source code profiles](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/predefined-profiles/#source-code).

For more details, refer to [DLP profiles](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/).

## 2025-01-15

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Export SSH command logs with Access for Infrastructure using Logpush**

Availability

Only available on Enterprise plans.

Cloudflare now allows you to send SSH command logs to storage destinations configured in [Logpush](https://developers.cloudflare.com/logs/logpush/), including third-party destinations. Once exported, analyze and audit the data as best fits your organization! For a list of available data fields, refer to the [SSH logs dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/ssh_logs/).

To set up a Logpush job, refer to [Logpush integration](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/).

## 2025-01-09

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2024.12.760.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains only a hotfix from the 2024.12.554.0 release.

**Changes and improvements:**

* Fixed an issue that could prevent clients with certain split tunnel configurations from connecting.

**Known issues:**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2024-12-19

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Escalate user submissions**

After you triage your users' submissions (that are machine reviewed), you can now escalate them to our team for reclassification (which are instead human reviewed). User submissions from the submission alias, PhishNet, and our API can all be escalated.

![Escalate](https://developers.cloudflare.com/_astro/Escalate.CwXPIyM3_1C9J30.webp)

From **Reclassifications**, go to **User submissions**. Select the three dots next to any of the user submissions, then select **Escalate** to create a team request for reclassification. The Cloudflare dashboard will then show you the submissions on the **Team Submissions** tab.

Refer to [User submissions](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/user-submissions/) to learn more about this feature.

This feature is available across these Email security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2024-12-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2024.12.554.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains improvements to support custom Gateway certificate installation in addition to the changes and improvements included in version 2024.12.492.0.

Note: If using macOS Sequoia, Cloudflare recommends the use of macOS 15.2 or later. With macOS 15.2, Apple addressed several issues that may have caused the WARP client to not behave as expected when used with macOS 15.0 and 15.1.

**Changes and improvements**:

* Adds support for installing all available custom Gateway certificates from an account to the system store.
* Users can now get a list of installed certificates by running `warp-cli certs`.

**Known issues:**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.2 or later.

## 2024-12-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2024.12.554.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains improvements to support custom Gateway certificate installation in addition to the changes and improvements included in version 2024.12.492.0.

**Changes and improvements:**

* Adds support for installing all available custom Gateway certificates from an account to the system store.
* Users can now get a list of installed certificates by running `warp-cli certs`.

**Known issues:**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2024-12-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2024.12.492.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

Note: If using macOS Sequoia, Cloudflare recommends the use of macOS 15.2 or later. With macOS 15.2, Apple addressed several issues that may have caused the WARP client to not behave as expected when used with macOS 15.0 and 15.1.

**Changes and improvements:**

* Consumers can now set the tunnel protocol using `warp-cli tunnel protocol set <protocol>`.
* Extended diagnostics collection time in `warp-diag` to ensure logs are captured reliably.
* Improved captive portal support by disabling the firewall during captive portal login flows.
* Improved reliability of connection establishment logic under degraded network conditions.
* Improved reconnection speed when a Cloudflare server is in a degraded state.
* Improved captive portal detection on certain public networks.
* Fixed an issue where admin override displayed an incorrect override end time.
* Reduced connectivity interruptions on WireGuard Split Tunnel Include mode configurations.
* Fixed connectivity issues switching between managed network profiles with different configured protocols.
* QLogs are now disabled by default and can be enabled with `warp-cli debug qlog enable`. The QLog setting from previous releases will no longer be respected.

**Known issues:**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.2 or later.

## 2024-12-19

[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

**Troubleshoot tunnels with diagnostic logs**

The latest `cloudflared` build [2024.12.2](https://github.com/cloudflare/cloudflared/releases/tag/2024.12.2) introduces the ability to collect all the diagnostic logs needed to troubleshoot a `cloudflared` instance.

A diagnostic report collects data from a single instance of `cloudflared` running on the local machine and outputs it to a `cloudflared-diag` file.

The `cloudflared-diag-YYYY-MM-DDThh-mm-ss.zip` archive contains the files listed below. The data in a file either applies to the `cloudflared` instance being diagnosed (`diagnosee`) or the instance that triggered the diagnosis (`diagnoser`). For example, if your tunnel is running in a Docker container, the diagnosee is the Docker instance and the diagnoser is the host instance.

| File name | Description | Instance |
| - | - | - |
| `cli-configuration.json` | [Tunnel run parameters](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/run-parameters/) used when starting the tunnel | diagnosee |
| `cloudflared_logs.txt` | [Tunnel log file](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/logs/)[1](#user-content-fn-1) | diagnosee |
| `configuration.json` | Tunnel configuration parameters | diagnosee |
| `goroutine.pprof` | goroutine profile made available by `pprof` | diagnosee |
| `heap.pprof` | heap profile made available by `pprof` | diagnosee |
| `metrics.txt` | Snapshot of [Tunnel metrics](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/metrics/#available-metrics) at the time of diagnosis | diagnosee |
| `network.txt` | JSON traceroutes to Cloudflare's global network using IPv4 and IPv6 | diagnoser |
| `raw-network.txt` | Raw traceroutes to Cloudflare's global network using IPv4 and IPv6 | diagnoser |
| `systeminformation.json` | Operating system information and resource usage | diagnosee |
| `task-result.json` | Result of each diagnostic task | diagnoser |
| `tunnelstate.json` | Tunnel connections at the time of diagnosis | diagnosee |

## Footnotes

1. If the log file is blank, you may need to [set `--loglevel` to `debug`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/logs/#view-logs-on-the-server) when you start the tunnel. The `--loglevel` parameter is only required if you ran the tunnel from the CLI using a `cloudflared tunnel run` command. It is not necessary if the tunnel runs as a Linux/macOS service or runs in Docker/Kubernetes. [↩](#user-content-fnref-1)

For more information, refer to [Diagnostic logs](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/troubleshoot-tunnels/diag-logs/).

## 2024-12-19

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Increased transparency for phishing email submissions**

You now have more transparency about team and user submissions for phishing emails through a **Reclassification** tab in the Zero Trust dashboard.

Reclassifications happen when users or admins [submit a phish](https://developers.cloudflare.com/cloudflare-one/email-security/settings/phish-submissions/) to Email security. Cloudflare reviews and - in some cases - reclassifies these emails based on improvements to our machine learning models.

This new tab increases your visibility into this process, allowing you to view what submissions you have made and what the outcomes of those submissions are.

![Use the Reclassification area to review submitted phishing emails](https://developers.cloudflare.com/_astro/reclassifications-tab.yDgtjG51_Z9zOJU.webp)

## 2024-12-19

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Linux (version 2024.12.554.0)**

A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release includes fixes and minor improvements.

**Changes and improvements**

* Consumers can now set the tunnel protocol using `warp-cli tunnel protocol set <protocol>`.
* Extended diagnostics collection time in `warp-diag` to ensure logs are captured reliably.
* Improved captive portal support by disabling the firewall during captive portal login flows.
* Improved reliability of connection establishment logic under degraded network conditions.
* Improved reconnection speed when a Cloudflare server is in a degraded state.
* Improved captive portal detection on certain public networks.
* Reduced connectivity interruptions on WireGuard Split Tunnel Include mode configurations.
* Fixed connectivity issues switching between managed network profiles with different configured protocols.
* QLogs are now disabled by default and can be enabled with `warp-cli debug qlog enable`. The QLog setting from previous releases will no longer be respected.

## 2024-12-18

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2024.12.492.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements:**

* Consumers can now set the tunnel protocol using `warp-cli tunnel protocol set <protocol>`.
* Extended diagnostics collection time in `warp-diag` to ensure logs are captured reliably.
* Improved captive portal support by disabling the firewall during captive portal login flows.
* Improved captive portal detection on certain public networks.
* Improved reconnection speed when a Cloudflare server is in a degraded state.
* Fixed an issue where WARP may fail to remove certificates from the user store in Device Information Only mode.
* Ensured at most one Powershell instance is opened when fetching the device serial number for posture checks.
* Fixed an issue to prevent the daemon from following Windows junctions created by non-admin users that could be used to delete files as SYSTEM user and potentially gain SYSTEM user privileges.
* Improved reliability of connection establishment logic under degraded network conditions.
* Fixed an issue that caused high memory usage when viewing connection statistics for extended periods of time.
* Improved WARP connectivity in environments with virtual interfaces from VirtualBox, VMware, and similar tools.
* Reduced connectivity interruptions on WireGuard Split Tunnel Include mode configurations.
* Fixed connectivity issues switching between managed network profiles with different configured protocols.
* QLogs are now disabled by default and can be enabled with `warp-cli debug qlog enable`. The QLog setting from previous releases will no longer be respected.

**Known issues:**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2024-12-17

[Magic Transit ](https://developers.cloudflare.com/magic-transit/)[Magic WAN ](https://developers.cloudflare.com/magic-wan/)[Network Interconnect](https://developers.cloudflare.com/network-interconnect/)

**Establish BGP peering over Direct CNI circuits**

Magic WAN and Magic Transit customers can use the Cloudflare dashboard to configure and manage BGP peering between their networks and their Magic routing table when using a Direct CNI on-ramp.

Using BGP peering with a CNI allows customers to:

* Automate the process of adding or removing networks and subnets.
* Take advantage of failure detection and session recovery features.

With this functionality, customers can:

* Establish an eBGP session between their devices and the Magic WAN / Magic Transit service when connected via CNI.
* Secure the session by MD5 authentication to prevent misconfigurations.
* Exchange routes dynamically between their devices and their Magic routing table.

Refer to [Magic WAN BGP peering](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/#configure-bgp-routes) or [Magic Transit BGP peering](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-bgp-routes) to learn more about this feature and how to set it up.

## 2024-12-13

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2024.12.326.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements.

**Changes and improvements:**

* Fixed connectivity issues switching between managed network profiles with different configured protocols.
* Added support for multiple users on shared Windows 10 and Windows 11 devices. Once a user completes the Windows login, all traffic to Cloudflare will be attributed to the currently active Windows user account. Contact your Customer Success Manager to request participation in this beta.

**Known issues:**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2024-12-06

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2024.11.688.1)**

A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements.

**Changes and improvements:**

* Consumers can now set the tunnel protocol using "warp-cli tunnel protocol set \<proto>".
* Extended diagnostics collection time in warp-diag to ensure logs are captured reliably.
* Improved captive portal support by disabling the firewall during captive portal login flows.
* Improved captive portal detection on certain public networks.
* Improved reconnection speed when a Cloudflare server is in a degraded state.
* Fixed an issue where WARP may fail to remove certificates from the user store in device information only mode.
* Ensured at most one powershell instance is opened when fetching the device serial number for posture checks.
* Fixed an issue to prevent the daemon from following Windows junctions created by non-admin users that could be used to delete files as SYSTEM user and potentially gain SYSTEM user privileges.
* Improved reliability of connection establishment logic under degraded network conditions.
* Fixed an issue that caused high memory usage when viewing connection statistics for extended periods of time.
* Improved WARP connectivity in environments with virtual interfaces from VirtualBox, VMware, and similar tools.
* Reduced connectivity interruptions on WireGuard include split tunnel configurations.

**Known issues:**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, please reconnect the WARP client by toggling off and back on.

## 2024-12-05

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2024.11.688.1)**

A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

This release contains minor fixes and improvements.

Note: If using macOS Sequoia, Cloudflare recommends the use of macOS 15.1 or later. With macOS 15.1, Apple addressed several issues that may have caused the WARP client to not behave as expected when used with macOS 15.0.x.

**Changes and improvements:**

* Consumers can now set the tunnel protocol using `warp-cli tunnel protocol set <protocol>`.
* Extended diagnostics collection time in `warp-diag` to ensure logs are captured reliably.
* Improved captive portal support by disabling the firewall during captive portal login flows.
* Improved reliability of connection establishment logic under degraded network conditions.
* Improved reconnection speed when a Cloudflare server is in a degraded state.
* Improved captive portal detection on certain public networks.
* Fixed an issue where admin override displayed an incorrect override end time.
* Reduced connectivity interruptions on WireGuard Split Tunnel Include mode configurations.

**Known issues:**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.1 or later.

## 2024-12-05

[Magic Cloud Networking](https://developers.cloudflare.com/magic-cloud-networking/)

**Generate customized terraform files for building cloud network on-ramps**

You can now generate customized terraform files for building cloud network on-ramps to [Magic WAN](https://developers.cloudflare.com/magic-wan/).

[Magic Cloud](https://developers.cloudflare.com/magic-cloud-networking/) can scan and discover existing network resources and generate the required terraform files to automate cloud resource deployment using their existing infrastructure-as-code workflows for cloud automation.

You might want to do this to:

* Review the proposed configuration for an on-ramp before deploying it with Cloudflare.
* Deploy the on-ramp using your own infrastructure-as-code pipeline instead of deploying it with Cloudflare.

For more details, refer to [Set up with Terraform](https://developers.cloudflare.com/magic-cloud-networking/cloud-on-ramps/#set-up-with-terraform).

## 2024-11-22

[CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

**Find security misconfigurations in your AWS cloud environment**

You can now use CASB to find security misconfigurations in your AWS cloud environment using [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).

You can also [connect your AWS compute account](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/aws-s3/#compute-account) to extract and scan your S3 buckets for sensitive data while avoiding egress fees. CASB will scan any objects that exist in the bucket at the time of configuration.

To connect a compute account to your AWS integration:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Cloud & SaaS findings** > **Integrations**.
2. Find and select your AWS integration.
3. Select **Open connection instructions**.
4. Follow the instructions provided to connect a new compute account.
5. Select **Refresh**.

## 2024-11-21

[Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

**Improved non-English keyboard support**

You can now type in languages that use diacritics (like á or ç) and character-based scripts (such as Chinese, Japanese, and Korean) directly within the remote browser. The isolated browser now properly recognizes non-English keyboard input, eliminating the need to copy and paste content from a local browser or device.

## 2024-11-18

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for Windows (version 2024.11.309.0)**

A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains minor fixes and improvements.

**Changes and improvements:**

* Fixed an issue where SSH sessions and other application connections over TCP or UDP could drop when a device that is using MASQUE changes its primary network interface.
* Fixed an issue to ensure the Cloudflare root certificate (or custom certificate) is installed in the trust store if not already there.
* Fixed an issue with the WARP client becoming unresponsive during startup.
* Extended diagnostics collection time in `warp-diag` to ensure logs are captured reliably.
* Fixed an issue that was preventing proper operation of DNS-over-TLS (DoT) for consumer users.

**Known issues:**

* DNS resolution may be broken when the following conditions are all true:

  * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
  * A custom DNS server address is configured on the primary network adapter.
  * The custom DNS server address on the primary network adapter is changed while WARP is connected.

  To work around this issue, reconnect the WARP client by toggling off and back on.

## 2024-11-18

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**WARP client for macOS (version 2024.11.309.0)**

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

This release contains reliability improvements and general bug fixes.

**Changes and improvements:**

* Fixed an issue where SSH sessions and other application connections over TCP or UDP could drop when a device that is using MASQUE changes its primary network interface.
* Fixed an issue to ensure the Cloudflare root certificate (or custom certificate) is installed in the trust store if not already there.
* Fixed an issue with the WARP client becoming unresponsive during startup.
* Extended `warp-diag` to collect system profiler firewall state as part of diagnostics.
* Fixed an issue with the WARP client becoming unresponsive while handling LAN inclusion.
* Fixed an issue where users were unable to connect with an IPC error message displayed in the UI.
* Fixed an issue that was preventing proper operation of DNS-over-TLS (DoT) for consumer users.

**Known issues:**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.1 or later.

## 2024-11-07

[Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

**Use Logpush for Email security user actions**

You can now send user action logs for Email security to an endpoint of your choice with Cloudflare Logpush.

Filter logs matching specific criteria you have set or select from multiple fields you want to send. For all users, we will log the date and time, user ID, IP address, details about the message they accessed, and what actions they took.

When creating a new Logpush job, remember to select **Audit logs** as the dataset and filter by:

* **Field**: `"ResourceType"`
* **Operator**: `"starts with"`
* **Value**: `"email_security"`.

![Logpush-user-actions](https://developers.cloudflare.com/_astro/Logpush-User-Actions.D14fWgmq_Z1FGUyR.webp)

For more information, refer to [Enable user action logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/enable-logs/#enable-user-action-logs).

This feature is available across all Email security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2024-10-02

[Magic Firewall](https://developers.cloudflare.com/magic-firewall/)

**Search for custom rules using rule name and/or ID**

The Magic Firewall dashboard now allows you to search custom rules using the rule name and/or ID.

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Analytics & Logs** > **Network Analytics**.
3. Select **Magic Firewall**.
4. Add a filter for **Rule ID**.

![Search for firewall rules with rule IDs](https://developers.cloudflare.com/_astro/search-with-rule-id.DJgzqgKk_1uO0HJ.webp)

Additionally, the rule ID URL link has been added to Network Analytics.

For more details about rules, refer to [Add rules](https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/add-rules/).

## 2024-10-01

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

**Eliminate long-lived credentials and enhance SSH security with Cloudflare Access for Infrastructure**

Organizations can now eliminate long-lived credentials from their SSH setup and enable strong multi-factor authentication for SSH access, similar to other Access applications, all while generating access and command logs.

SSH with [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/infrastructure-apps/) uses short-lived SSH certificates from Cloudflare, eliminating SSH key management and reducing the security risks associated with lost or stolen keys. It also leverages a common deployment model for Cloudflare One customers: [WARP-to-Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-warp-to-tunnel/).

SSH with Access for Infrastructure enables you to:

* **Author fine-grained policy** to control who may access your SSH servers, including specific ports, protocols, and SSH users.
* **Monitor infrastructure access** with Access and SSH command logs, supporting regulatory compliance and providing visibility in case of security breach.
* **Preserve your end users' workflows.** SSH with Access for Infrastructure supports native SSH clients and does not require any modifications to users’ SSH configs.

![Example of an infrastructure Access application](https://developers.cloudflare.com/_astro/infrastructure-app.BhpJOgxs_Z1Ixiie.webp)

To get started, refer to [SSH with Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/).

## 2024-06-17

[Risk Score](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/)

**Exchange user risk scores with Okta**

Beyond the controls in [Zero Trust](https://developers.cloudflare.com/cloudflare-one/), you can now [exchange user risk scores](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/risk-score/#send-risk-score-to-okta) with Okta to inform SSO-level policies.

First, configure Cloudflare One to send user risk scores to Okta.

1. Set up the [Okta SSO integration](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta/).
2. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Integrations** > **Identity providers**.
3. In **Your identity providers**, locate your Okta integration and select **Edit**.
4. Turn on **Send risk score to Okta**.
5. Select **Save**.
6. Upon saving, Cloudflare One will display the well-known URL for your organization. Copy the value.

Next, configure Okta to receive your risk scores.

1. On your Okta admin dashboard, go to **Security** > **Device Integrations**.
2. Go to **Receive shared signals**, then select **Create stream**.
3. Name your integration. In **Set up integration with**, choose *Well-known URL*.
4. In **Well-known URL**, enter the well-known URL value provided by Cloudflare One.
5. Select **Create**.

## 2024-06-16

[Access ](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)[Browser Isolation ](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)[CASB ](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)[Cloudflare Tunnel ](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)[Digital Experience Monitoring ](https://developers.cloudflare.com/cloudflare-one/insights/dex/)[Data Loss Prevention ](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)[Email security ](https://developers.cloudflare.com/cloudflare-one/email-security/)[Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Magic Cloud Networking ](https://developers.cloudflare.com/magic-cloud-networking/)[Magic Firewall ](https://developers.cloudflare.com/magic-firewall/)[Magic Network Monitoring ](https://developers.cloudflare.com/magic-network-monitoring/)[Magic Transit ](https://developers.cloudflare.com/magic-transit/)[Magic WAN ](https://developers.cloudflare.com/magic-wan/)[Network Interconnect ](https://developers.cloudflare.com/network-interconnect/)[Risk Score ](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/)[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

**Explore product updates for Cloudflare One**

Welcome to your new home for product updates on [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/).

Our [new changelog](https://developers.cloudflare.com/changelog/) lets you read about changes in much more depth, offering in-depth examples, images, code samples, and even gifs.

If you are looking for older product updates, refer to the following locations.

Older product updates

* [Access](https://developers.cloudflare.com/cloudflare-one/changelog/access/)
* [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/changelog/browser-isolation/)
* [CASB](https://developers.cloudflare.com/cloudflare-one/changelog/casb/)
* [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/changelog/tunnel/)
* [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/changelog/dlp/)
* [Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/changelog/dex/)
* [Email security](https://developers.cloudflare.com/cloudflare-one/changelog/email-security/)
* [Gateway](https://developers.cloudflare.com/cloudflare-one/changelog/gateway/)
* [Magic Cloud Networking](https://developers.cloudflare.com/magic-cloud-networking/changelog/)
* [Magic Firewall](https://developers.cloudflare.com/magic-firewall/changelog/)
* [Magic Network Monitoring](https://developers.cloudflare.com/magic-network-monitoring/changelog/)
* [Magic Transit](https://developers.cloudflare.com/magic-transit/changelog/)
* [Magic WAN](https://developers.cloudflare.com/magic-wan/changelog/)
* [Network Interconnect](https://developers.cloudflare.com/network-interconnect/changelog/)
* [Risk score](https://developers.cloudflare.com/cloudflare-one/changelog/risk-score/)
* [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/changelog/warp/)
