---
title: Managed deployment · Cloudflare One docs
description: Organizations can deploy WARP automatically to their fleet of
  devices in a single operation. The WARP client is compatible with the vast
  majority of managed deployment workflows, including mobility management
  solutions such as Intune or JAMF, or by executing an .msi file on desktop
  machines.
lastUpdated: 2025-11-14T21:15:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/index.md
---

Organizations can deploy WARP automatically to their fleet of devices in a single operation. The WARP client is compatible with the vast majority of managed deployment workflows, including [mobility management solutions](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/partners/) such as Intune or JAMF, or by executing an `.msi` file on desktop machines.

This page provides generic instructions for an automated deployment. If you want to deploy the WARP client manually, refer to the [instructions for manual deployment](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/).

Warning

[MDM parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) that you specify in a local policy file will overrule any [WARP settings](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/) configured in the dashboard.

## Prerequisites

* Refer to the [Download page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/#windows) to review system requirements and download the installer for your operating system.

* After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.

## Windows

The WARP client for Windows allows for an automated install via tools like Intune, AD, or any script or management tool that can execute a `.msi` file.

### Install WARP

To install the WARP client, run the following command:

```bash
msiexec /i "Cloudflare_WARP_<VERSION>.msi" /qn ORGANIZATION="your-team-name" SUPPORT_URL="http://support.example.com"
```

#### Supported properties

The WARP MSI installer supports the following [public properties](https://learn.microsoft.com/en-us/windows/win32/msi/public-properties):

* `ORGANIZATION`
* `GATEWAY_UNIQUE_ID`
* `AUTH_CLIENT_ID`
* `AUTH_CLIENT_SECRET`
* `ONBOARDING`
* `OVERRIDE_API_ENDPOINT`
* `OVERRIDE_DOH_ENDPOINT`
* `OVERRIDE_WARP_ENDPOINT`
* `SERVICE_MODE`
* `SUPPORT_URL`
* `SWITCH_LOCKED`

Refer to [deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) for a description of each property.

### Uninstall WARP

To uninstall the WARP client:

1. First, locate the `.msi` package with the following PowerShell command:

```powershell
Get-WmiObject Win32_Product | Where-Object { $_.Name -match "WARP" } | Sort-Object -Property Name | Format-Table IdentifyingNumber, Name, LocalPackage -AutoSize
```

```txt
IdentifyingNumber                      Name            LocalPackage
-----------------                      ----            ------------
{5RA4DJWK-13D8-2NSX-QRF8-UANLODWD6D90} Cloudflare WARP C:\WINDOWS\Installer\3f476db.msi
```

1. You can then use the LocalPackage output in the uninstall command. For example,

```powershell
msiexec /x C:\WINDOWS\Installer\<WARP_RELEASE>.msi /quiet
```

### Update MDM parameters

The on-disk configuration of the Windows client can be changed at any time by modifying or replacing the contents of `C:\ProgramData\Cloudflare\mdm.xml`. The format of this file is as follows:

```xml
<dict>
  <key>organization</key>
  <string>your-team-name</string>
  <key>onboarding</key>
  <false/>
</dict>
```

Changes to this file are processed immediately by the WARP client.

### Authenticate in embedded browser

By default WARP will use the user's default browser to perform registration. You can override the default setting to instead authenticate users in an embedded browser. The embedded browser will work around any protocol handler issues that may prevent the default browser from launching.

To use an embedded browser:

1. Download and install WebView2 by following the [Microsoft instructions](https://developer.microsoft.com/en-us/microsoft-edge/webview2/#download-section).

2. Add a registry key with the following command:

   ```txt
   REG ADD HKLM\SOFTWARE\Cloudflare\CloudflareWARP /f /v UseWebView2 /t REG_SZ /d y
   ```

The WARP client will now launch WebView2 when the user is registering their device with Zero Trust.

## macOS

The WARP client for macOS allows for an automated install via tools like Jamf, Intune, Kandji, or JumpCloud or any script or management tool that can place a `com.cloudflare.warp.plist` file in `/Library/Managed Preferences`. The plist can also be wrapped in a `.mobileconfig`.

Warning

Do not deploy WARP via [Intune's line-of-business (LOB) deployment method](https://learn.microsoft.com/en-us/intune/intune-service/apps/lob-apps-macos). This deployment type is not supported. Use [Intune's `.pkg` deployment method](https://learn.microsoft.com/en-us/intune/intune-service/apps/macos-unmanaged-pkg) instead to successfully install the WARP client on macOS.

If you do not wish to use a management tool, you can manually place an `mdm.xml` file in `/Library/Application Support/Cloudflare`.

### Prepare file for MDM deployment

#### `plist` file

1. [Download](https://developers.cloudflare.com/cloudflare-one/static/mdm/com.cloudflare.warp.plist) an example `com.cloudflare.warp.plist` file.

2. Modify the file with your desired [deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/).

#### `mobileconfig` file

1. [Download](https://developers.cloudflare.com/cloudflare-one/static/mdm/CloudflareWARP.mobileconfig) an example `.mobileconfig` file.

2. Run `uuidgen` from your macOS Terminal. This will generate a value for `PayloadUUID`, which you can use to replace the default value used for `PayloadUUID`.

3. Modify the file with your desired [deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/).

### Place an unmanaged `mdm.xml` file

You can configure [WARP deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) on macOS by manually placing an `mdm.xml` file in `/Library/Application Support/Cloudflare`. This deployment method is an alternative to pushing a `plist` or `mobileconfig` using an MDM tool.

The format of `/Library/Application Support/Cloudflare/mdm.xml` is as follows:

```xml
<dict>
  <key>organization</key>
  <string>your-team-name</string>
</dict>
```

## Linux

The WARP client for Linux allows for an automated install via the presence of an `mdm.xml` file in `/var/lib/cloudflare-warp`. The format of `/var/lib/cloudflare-warp/mdm.xml` is as follows:

```xml
<dict>
  <key>organization</key>
  <string>your-team-name</string>
</dict>
```

Refer to [deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) for a list of accepted arguments.

To learn how to automate WARP deployment on headless servers, refer to our [tutorial](https://developers.cloudflare.com/cloudflare-one/tutorials/warp-on-headless-linux/).

## iOS

Migrate from 1.1.1.1

The legacy iOS client, [1.1.1.1: Faster Internet](https://apps.apple.com/us/app/1-1-1-1-faster-internet/id1423538627), has been replaced by the Cloudflare One Agent. Learn more in our [migration guide](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/cloudflare-one-agent-migration/).

The Cloudflare WARP iOS client, known in the App Store as [Cloudflare One Agent](https://apps.apple.com/us/app/cloudflare-one-agent/id6443476492), allows for an automated install via tools like Jamf, Intune, or SimpleMDM.

To proceed with the installation, here is an example of the XML code you will need:

```xml
<dict>
    <key>organization</key>
    <string>your-team-name</string>
    <key>auto_connect</key>
    <integer>1</integer>
    <key>switch_locked</key>
    <false />
    <key>service_mode</key>
    <string>warp</string>
    <key>support_url</key>
    <string>https://support.example.com</string>
</dict>
```

Refer to [deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) for a description of each argument.

## Android / ChromeOS

Migrate from 1.1.1.1

The legacy Android client, [1.1.1.1 + WARP: Safer Internet](https://play.google.com/store/apps/details?id=com.cloudflare.onedotonedotonedotone), has been replaced by the Cloudflare One Agent. Learn more in our [migration guide](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/cloudflare-one-agent-migration/).

The Cloudflare WARP Android client, known in the Google Play store as [Cloudflare One Agent](https://play.google.com/store/apps/details?id=com.cloudflare.cloudflareoneagent), allows for an automated install via tools like Intune, Google Endpoint Manager, and others.

To proceed with the installation, here is an example of the XML code you will need:

```xml
<key>organization</key>
<string>your-team-name</string>
<key>switch_locked</key>
<true />
<key>auto_connect</key>
<integer>0</integer>
<key>gateway_unique_id</key>
<string>your_gateway_doh_subdomain</string>
<key>service_mode</key>
<string>warp</string>
<key>support_url</key>
<string>https://support.example.com</string>
```

If your MDM tool does not support XML, you may need to convert the XML to JSON. Here is an example below:

```json
{
  "organization": "your-team-name",
  "gateway_unique_id": "your_gateway_doh_subdomain",
  "onboarding": true,
  "switch_locked": true,
  "auto_connect": 0,
  "service_mode": "warp",
  "support_url": "https://support.example.com"
}
```

Refer to [deployment parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) for a description of each value.
