---
title: Set up DNS Firewall · Cloudflare DNS docs
description: Set up DNS Firewall to protect upstream nameservers from DDoS
  attacks and reduce load by caching DNS responses.
lastUpdated: 2025-11-17T14:08:01.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/dns-firewall/setup/
  md: https://developers.cloudflare.com/dns/dns-firewall/setup/index.md
---

## Prerequisites

Prior to setting up DNS Firewall, you need:

* Account access to DNS Firewall (provided by your Enterprise account team).
* Access to **DNS Administrator** or **Super Administrator** privileges on your account.
* Newly updated IP addresses for your nameservers (protects against previously compromised IP addresses).

## Configure DNS Firewall

### Create a DNS Firewall cluster

* Dashboard

  1. In the Cloudflare dashboard, go to the **DNS Firewall Clusters** page.

     [Go to **Clusters**](https://dash.cloudflare.com/?to=/:account/dns-firewall/clusters)

  2. Select **Add Firewall Cluster**.

  3. Fill out the required fields, including:

     * **IP Addresses**: The upstream IPv4 and/or IPv6 addresses of your authoritative nameservers.
     * **Minimum Cache TTL**: Recommended setting of **30 seconds**.
     * **Maximum Cache TTL**: Recommended setting of **4 hours**. Larger values increase the cache hit ratio, but also increase the time required for DNS changes to propagate.
     * **ANY queries**: Recommended setting is **Off** because these are often used as part of DDoS attacks. Also refer to this [blog post](https://blog.cloudflare.com/rfc8482-saying-goodbye-to-any/).

  4. Click **Continue**.

  5. On the following screen, save the values for **Your new DNS Firewall IP Addresses**.

  Note:

  If you forget to save your new IP addresses, find your cluster and click **IP Addresses**.

  If you delete your cluster, the assigned set of IPs will be lost. If you recreate the cluster you will get a different set of IPs.

* API

  You can also create a DNS Firewall cluster by sending a [POST request](https://developers.cloudflare.com/api/resources/dns_firewall/methods/create/) to the API.

### Update registrar settings

Update the `A/AAAA` glue records for your nameserver hostnames at your registrar with your DNS Firewall cluster IP addresses.

### Update DNS servers

At your DNS servers, update the `A/AAAA` records for your nameserver hostnames in your DNS zone file with your DNS Firewall cluster IP addresses.

### Test DNS resolution

Confirm that your nameservers are functioning correctly by running a `dig` command.

### Update security policies

Configure security policy in your DNS servers and Firewall to allow only [Cloudflare IPs](https://cloudflare.com/ips) and TCP/UDP port 53.

## Additional options

When you use the API, you can also specify other parameters, such as rate limit (in queries per second per data center). You can find the parameters descriptions and examples in the [API documentation](https://developers.cloudflare.com/api/resources/dns_firewall/methods/create/).

To configure rate limiting and other options for already existing clusters, use the [Update DNS Firewall Cluster](https://developers.cloudflare.com/api/resources/dns_firewall/methods/edit/) endpoint.
