---
title: Manage Page Rules · Cloudflare Rules docs
description: You can manage Page Rules in the Cloudflare dashboard or via API.
lastUpdated: 2025-09-24T12:01:01.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/page-rules/manage/
  md: https://developers.cloudflare.com/rules/page-rules/manage/index.md
---

You can manage Page Rules in the Cloudflare dashboard or via API.

Note

Consider alternative [Rules](https://developers.cloudflare.com/rules/) options due to their enhanced configurability. Refer to the [migration guide](https://developers.cloudflare.com/rules/reference/page-rules-migration/) for details.

For more flexibility and customization, consider using [Snippets](https://developers.cloudflare.com/rules/snippets/).

## Create a page rule

* Dashboard

  To create a page rule in the dashboard:

  1. In the Cloudflare dashboard, go to the **Page Rules** page.

     [Go to **Page Rules**](https://dash.cloudflare.com/?to=/:account/:zone/rules/page-rules)

  2. Select **Create Page Rule**.

  3. For **URL**, enter the URL or URL pattern that should match the rule ([more details about wildcard matching](https://developers.cloudflare.com/rules/page-rules/reference/wildcard-matching/)).

  4. For **Pick a Setting**, select a [Cloudflare setting](https://developers.cloudflare.com/rules/page-rules/reference/settings/) to adjust. If desired, select **Add a Setting** to adjust multiple Cloudflare settings with the same rule.

  5. In the **Order** dropdown, specify the desired order: *First, Last* or *Custom*.

  6. To save and deploy your rule, select **Save and Deploy Page Rule**. If you are not ready to deploy your rule, select **Save as Draft**.

     If you are matching a hostname in your rule expression, you may be prompted to create a proxied DNS record for that hostname. Refer to [Troubleshooting](https://developers.cloudflare.com/rules/reference/troubleshooting/#this-rule-may-not-apply-to-your-traffic) for more information.

  For ideas about what rules you can create, refer to [recommended rules](https://developers.cloudflare.com/rules/page-rules/reference/recommended-rules/).

* API

  To create a page rule using the API, send a [`POST` request](https://developers.cloudflare.com/api/resources/page_rules/methods/create/).

  You may also want to review the documentation on [wildcard matching](https://developers.cloudflare.com/rules/page-rules/reference/wildcard-matching/), [available settings](https://developers.cloudflare.com/rules/page-rules/reference/settings/), and [recommended rules](https://developers.cloudflare.com/rules/page-rules/reference/recommended-rules/).

Notes

* Page Rules require a [proxied DNS record](https://developers.cloudflare.com/dns/proxy-status/) to work. Page Rules will not apply to subdomains that do not exist in DNS or are not being directed to Cloudflare.

* Cloudflare does not support non-ASCII characters — such as punycode/unicode domain — in Page Rules. Instead, you could URL-encode the string using [Punycode converter](https://www.punycoder.com/).

## Edit a page rule

* Dashboard

  To edit a page rule in the dashboard:

  1. In the Cloudflare dashboard, go to the **Page Rules** page.

     [Go to **Page Rules**](https://dash.cloudflare.com/?to=/:account/:zone/rules/page-rules)

  2. For a specific rule:

     * To enable or disable the rule, select the on/off toggle.
     * To modify the URL pattern, settings, and order, select **Edit** (wrench icon). Then, enter the information you want to change.

* API

  To update one or more fields using the API, send a [`PATCH` request](https://developers.cloudflare.com/api/resources/page_rules/methods/edit/).

  To entirely replace the configuration of a page rule, send a [`PUT` request](https://developers.cloudflare.com/api/resources/page_rules/methods/update/).

## Delete a page rule

* Dashboard

  To delete a page rule in the dashboard:

  1. In the Cloudflare dashboard, go to the **Page Rules** page.

     [Go to **Page Rules**](https://dash.cloudflare.com/?to=/:account/:zone/rules/page-rules)

  2. For a specific rule, select **X**. Then, select **Delete**.

* API

  To delete a page rule using the API, send a [`DELETE` request](https://developers.cloudflare.com/api/resources/page_rules/methods/delete/).
