---
title: Request Header Transform Rules · Cloudflare Rules docs
description: Learn how to modify HTTP request headers with Cloudflare's rules.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/transform/request-header-modification/
  md: https://developers.cloudflare.com/rules/transform/request-header-modification/index.md
---

Use Request Header Transform Rules to manipulate the headers of HTTP requests sent to your origin server.

```mermaid
flowchart LR
accTitle: Header modifications diagram
accDescr: Header transform rules can change the headers sent to your origin server (request header modifications) or sent your your website visitors (response header modifications).

A[Visitor]
B((Cloudflare))
C[(Origin server)]

A -.-> B == "Includes request<br> header modifications" ==> C
C -.-> B -. "Includes response<br> header modifications" .-> A

style A stroke-width: 2px
style B stroke: orange,fill: orange,color: black
linkStyle 0,2,3 stroke-width: 1px
linkStyle 1 stroke-width: 3px
```



To modify HTTP headers in the **response** sent to website visitors, refer to [Response Header Transform Rules](https://developers.cloudflare.com/rules/transform/response-header-modification/).

Through Request Header Transform Rules you can:

* Set the value of an HTTP request header to a literal string value, overwriting its previous value or adding a new header to the request.
* Set the value of an HTTP request header according to an expression, overwriting its previous value or adding a new header to the request.
* Remove an HTTP header from the request.

You can create a request header transform rule [in the dashboard](https://developers.cloudflare.com/rules/transform/request-header-modification/create-dashboard/), [via API](https://developers.cloudflare.com/rules/transform/request-header-modification/create-api/), or [using Terraform](https://developers.cloudflare.com/terraform/additional-configurations/transform-rules/#create-a-request-header-transform-rule).

For more complex request header modifications, consider using [Snippets](https://developers.cloudflare.com/rules/snippets/).

## Important remarks

* You cannot modify or remove HTTP request headers whose name starts with `x-cf-` or `cf-` except for the `cf-connecting-ip` HTTP request header, which you can remove.

* Due to protocol compliance reasons, modifying or removing request headers with [forbidden header names](https://developer.mozilla.org/en-US/docs/Glossary/Forbidden_header_name) (such as `Accept-Encoding`) is generally not allowed in Request Header Transform Rules.

* You cannot modify the value of any header commonly used to identify the website visitor's IP address or initial protocol, such as `x-forwarded-for`, `true-client-ip`, `x-real-ip`, or `x-forwarded-proto`. Additionally, you cannot remove the `x-forwarded-for` and `x-forwarded-proto` headers.

* You cannot set or modify the value of `cookie` HTTP request headers, but you can remove these headers. Configuring a rule that removes the `cookie` HTTP request header will remove all `cookie` headers in matching requests.

* If you modify the value of an existing HTTP request header using an expression that evaluates to an empty string (`""`) or an undefined value, the HTTP request header is **removed**.

* The HTTP request header removal operation will remove all request headers with the provided name.

* Currently, there is a limited number of HTTP request headers that you cannot modify. Cloudflare may remove restrictions for some of these HTTP request headers when presented with valid use cases. [Create a post in the community](https://community.cloudflare.com) for consideration.

* To use [claims inside a JSON Web Token (JWT)](https://developers.cloudflare.com/api-shield/security/jwt-validation/transform-rules/), you must first set up a token validation configuration in API Shield.

## Troubleshooting

When troubleshooting Request Header Transform Rules, use [Cloudflare Trace](https://developers.cloudflare.com/rules/trace-request/) to determine if a rule is triggering for a specific URL.
