---
title: HTTP method — Domain Control Validation — SSL/TLS · Cloudflare SSL/TLS docs
description: When you choose HTTP DCV, Cloudflare automatically adds a
  verification HTTP token to your domain.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/http/
  md: https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/http/index.md
---

When you choose HTTP DCV, Cloudflare automatically adds a verification HTTP token to your domain.

Only use this method if your domain can tolerate a few minutes of downtime.

Note

If you encounter issues with HTTP DCV, refer to the [troubleshooting guide](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/troubleshooting/).

## Limitations

HTTP DCV is only available for [proxied domains](https://developers.cloudflare.com/dns/proxy-status/). It is possible to manually add the DCV token to the `.well-known/pki-validation/` directory on your origin web server to pre-validate your certificates.

HTTP DCV validation does not work for wildcard certificates. If you want to use wildcard certificates, use [TXT validation](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/txt/).

Based on your chosen certificate authority (CA), you may also not be able to use HTTP verification with [advanced certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/).

## Setup

### Specify DCV method

If you want to use a [Universal SSL certificate](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/enable-universal-ssl/), you will need to edit the `validation_method` [via the API](https://developers.cloudflare.com/api/resources/ssl/subresources/verification/methods/edit/) and specify your chosen validation method.

Alternatively, you could [order an advanced certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/#create-a-certificate) via the API.

In either case, you would need to set a `"validation_method":"http"` parameter.

### Review other Cloudflare settings

To make sure your domain does not accidentally block HTTP DCV, review your Cloudflare settings for [common setup issues](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/troubleshooting/).

### Complete DCV

Your HTTP token will be available for the certificate authority as soon as you finish your [partial domain setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/setup/#3-add-dns-records).

This means that you need to add a CNAME record to Cloudflare in your authoritative DNS and create [proxied DNS records](https://developers.cloudflare.com/dns/proxy-status/) for your hostname within Cloudflare.

This process may involve a few minutes of downtime.

What happens after you create your records

Cloudflare contacts one of our certificate authority (CA) providers and asks them to issue certificates for the specified hostname. The CA will then inform Cloudflare that we need to demonstrate control of this hostname by returning a `$DCV_TOKEN` at a specified `$DCV_FILENAME`; both the token and the filename are randomly generated by the CA and not known to Cloudflare ahead of time.

For example, if you create a new custom hostname for `site.example.com`, the CA might ask us to return the value `ca3-38734555d85e4421beb4a3e6d1645fe6` for a request to `http://site.example.com/.well-known/pki-validation/ca3-39f423f095be4983922ca0365308612d.txt"`. As soon as we receive that value from the CA we make it accessible at our edge and ask the CA to confirm it is there so that they can complete validation and the certificate order.

To check whether your certificates have been validated and reissued:

* **Dashboard**: Find the certificate(s) on the [**Edge Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/edge-certificates) page and make sure that the **Status** is **Active**.
* **API**: Send a [`GET`](https://developers.cloudflare.com/api/resources/ssl/subresources/certificate_packs/methods/list/) request and confirm that your certificate(s) have `"status": "active"`.

## Renewal

Even if you manually handle DCV when issuing certificates in a [partial DNS setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/), at certificate renewal, Cloudflare will attempt to automatically perform DCV via HTTP.

If all of the following conditions are confirmed at the first attempt, the renewal happens automatically via HTTP.

* Hostnames are proxied.
* Hostnames on the certificate resolve to the IPs assigned to the zone.
* The certificate does not contain wildcards.

Note

To automatically renew certificates that do not meet the referred criteria, consider using [Delegated DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/delegated-dcv/).
