---
title: Pre-clearance configuration · Cloudflare Turnstile docs
description: Pre-clearance allows Turnstile to issue clearance cookies that can
  be used across your Cloudflare-protected domains. This feature requires
  specific hostname configuration for proper functionality.
lastUpdated: 2025-11-17T17:38:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/additional-configuration/hostname-management/pre-clearance/
  md: https://developers.cloudflare.com/turnstile/additional-configuration/hostname-management/pre-clearance/index.md
---

[Pre-clearance](https://developers.cloudflare.com/cloudflare-challenges/concepts/clearance/#pre-clearance-support-in-turnstile) allows Turnstile to issue clearance cookies that can be used across your Cloudflare-protected domains. This feature requires specific hostname configuration for proper functionality.

## Prerequisites

For pre-clearance to work correctly, you must:

1. Use a registered Cloudflare zone.

   The hostname must be a zone registered in your Cloudflare account. When configuring your widget via the dashboard, you can select from existing zones.

2. Select the registered Cloudflare zone with intended WAF rule to set pre-clearance.

   The zone you select must contain the WAF rule you wish to set pre-clearance through Turnstile.

   For example, if you have `example.com` and `app.example.com` as registered zones and you want to have Turnstile issue pre-clearance for `app.example.com`, you must select `app.example.com`.

## Validation

The clearance cookie `cf_clearance` will only be accepted on domains that match the widget's configured hostnames, are registered as zones in your Cloudflare account, and have challenges enabled through Cloudflare's security settings.

If pre-clearance is configured incorrectly, clearance cookies may become invalid and lead to additional challenge requests.
